/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.models;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Crash
implements Cacheable {
    private String a;
    private String b;
    private String c;
    private ArrayList<Attachment> d;
    private State e;
    private CrashState f = CrashState.NOT_AVAILABLE;
    private boolean g;

    public Crash() {
    }

    public Crash(@NonNull String string, @NonNull State state) {
        this();
        this.a = string;
        this.e = state;
        this.d = new ArrayList(6);
    }

    public String a() {
        return this.a;
    }

    public Crash a(String string) {
        this.a = string;
        return this;
    }

    public String b() {
        return this.b;
    }

    public Crash b(String string) {
        this.b = string;
        return this;
    }

    public String c() {
        return this.c;
    }

    public Crash c(String string) {
        this.c = string;
        return this;
    }

    public Crash a(Uri uri) {
        return this.a(uri, Attachment.Type.ATTACHMENT_FILE);
    }

    public Crash a(Uri uri, Attachment.Type type) {
        if (uri == null) {
            InstabugSDKLogger.w((Object)this, (String)"Adding attachment with a null Uri, ignored.");
            return this;
        }
        Attachment attachment = new Attachment();
        attachment.setName(uri.getLastPathSegment());
        attachment.setLocalPath(uri.getPath());
        attachment.setType(type);
        this.d.add(attachment);
        return this;
    }

    public ArrayList<Attachment> d() {
        return this.d;
    }

    public Crash a(@NonNull ArrayList<Attachment> arrayList) {
        this.d = arrayList;
        return this;
    }

    public State e() {
        return this.e;
    }

    public Crash a(State state) {
        this.e = state;
        return this;
    }

    public CrashState f() {
        return this.f;
    }

    public Crash a(CrashState crashState) {
        this.f = crashState;
        return this;
    }

    public boolean g() {
        return this.g;
    }

    public Crash a(boolean bl) {
        this.g = bl;
        return this;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)this.a()).put("temporary_server_token", (Object)this.b()).put("crash_message", (Object)this.c()).put("crash_state", (Object)this.f().toString()).put("state", (Object)this.e().toJson()).put("attachments", (Object)Attachment.toJson(this.d())).put("handled", this.g());
        return jSONObject.toString();
    }

    public void fromJson(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        if (jSONObject.has("id")) {
            this.a(jSONObject.getString("id"));
        }
        if (jSONObject.has("temporary_server_token")) {
            this.b(jSONObject.getString("temporary_server_token"));
        }
        if (jSONObject.has("crash_message")) {
            this.c(jSONObject.getString("crash_message"));
        }
        if (jSONObject.has("crash_state")) {
            this.a(CrashState.valueOf(jSONObject.getString("crash_state")));
        }
        if (jSONObject.has("state")) {
            State state = new State();
            state.fromJson(jSONObject.getString("state"));
            this.a(state);
        }
        if (jSONObject.has("attachments")) {
            this.a(Attachment.fromJson((JSONArray)jSONObject.getJSONArray("attachments")));
        }
        if (jSONObject.has("handled")) {
            this.a(jSONObject.getBoolean("handled"));
        }
    }

    public String toString() {
        return "Internal Id: " + this.a + ", TemporaryServerToken:" + this.b + ", crashMessage:" + this.c + ", handled:" + this.g;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Crash) {
            Crash crash = (Crash)object;
            if (String.valueOf(crash.a()).equals(String.valueOf(this.a())) && String.valueOf(crash.c()).equals(String.valueOf(this.c())) && String.valueOf(crash.b()).equals(String.valueOf(this.b())) && crash.f() == this.f() && crash.e().equals((Object)this.e()) && crash.g() == this.g() && crash.d() != null && crash.d().size() == this.d().size()) {
                for (int i = 0; i < crash.d().size(); ++i) {
                    if (crash.d().get(i).equals((Object)this.d().get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.a() != null) {
            return this.a().hashCode();
        }
        return -1;
    }

    public static class a {
        @SuppressLint(value={"CheckResult"})
        public Crash a(Context context) {
            final Crash crash = new Crash(System.currentTimeMillis() + "", new State.Builder(context).build(true));
            if (InstabugCore.getFeatureState((Feature)Feature.REPRO_STEPS) == Feature.State.ENABLED && InstabugCore.isReproStepsScreenshotEnabled()) {
                VisualUserStepsHelper.getVisualUserStepsFileObservable((Context)context, (String)crash.a()).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<Uri>(){

                    public void a(Uri uri) {
                        crash.a(uri, Attachment.Type.VISUAL_USER_STEPS);
                    }

                    public /* synthetic */ void accept(Object object) throws Exception {
                        this.a((Uri)object);
                    }
                });
            }
            return crash;
        }
    }

    public static enum CrashState {
        READY_TO_BE_SENT,
        LOGS_READY_TO_BE_UPLOADED,
        ATTACHMENTS_READY_TO_BE_UPLOADED,
        NOT_AVAILABLE,
        WAITING_FOR_SCREEN_RECORDING_TO_BE_TRIMMED;

    }
}

