/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.Context;
import com.instabug.crash.cache.CrashesCacheManager;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.a;
import com.instabug.library.network.InstabugNetworkBasedBackgroundService;
import com.instabug.library.network.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;

public class InstabugCrashesUploaderService
extends InstabugNetworkBasedBackgroundService {
    protected void runBackgroundTask() throws Exception {
        this.a();
    }

    private void a() throws IOException, JSONException {
        InstabugSDKLogger.d((Object)((Object)this), (String)("Found " + CrashesCacheManager.getCrashes().size() + " crashes in cache"));
        for (final Crash crash : CrashesCacheManager.getCrashes()) {
            if (crash.f().equals((Object)Crash.CrashState.READY_TO_BE_SENT)) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("Uploading crash: " + crash.toString()));
                a.a().a((Context)this, crash, new Request.Callbacks<String, Throwable>(){

                    public void a(String string) {
                        InstabugSDKLogger.d((Object)((Object)InstabugCrashesUploaderService.this), (String)("crash uploaded successfully, setting crash TemporaryServerToken equal " + string));
                        crash.b(string);
                        crash.a(Crash.CrashState.LOGS_READY_TO_BE_UPLOADED);
                        CrashesCacheManager.saveCacheToDisk();
                        InstabugCrashesUploaderService.this.a(crash);
                        InstabugCrashesUploaderService.this.b();
                    }

                    public void a(Throwable throwable) {
                        InstabugSDKLogger.d((Object)((Object)InstabugCrashesUploaderService.this), (String)"Something went wrong while uploading crash");
                    }

                    public /* synthetic */ void onFailed(Object object) {
                        this.a((Throwable)object);
                    }

                    public /* synthetic */ void onSucceeded(Object object) {
                        this.a((String)object);
                    }
                });
                continue;
            }
            if (crash.f().equals((Object)Crash.CrashState.LOGS_READY_TO_BE_UPLOADED)) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("crash: " + crash.toString() + " already uploaded but has unsent logs, uploading now"));
                this.a(crash);
                continue;
            }
            if (!crash.f().equals((Object)Crash.CrashState.ATTACHMENTS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.d((Object)((Object)this), (String)("crash: " + crash.toString() + " already uploaded but has unsent attachments, uploading now"));
            this.b(crash);
        }
    }

    private void a(final Crash crash) {
        InstabugSDKLogger.d((Object)((Object)this), (String)("START uploading all logs related to this crash id = " + crash.a()));
        a.a().c((Context)this, crash, new Request.Callbacks<Boolean, Crash>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.d((Object)((Object)InstabugCrashesUploaderService.this), (String)"crash logs uploaded successfully, change its state");
                crash.a(Crash.CrashState.ATTACHMENTS_READY_TO_BE_UPLOADED);
                CrashesCacheManager.saveCacheToDisk();
                try {
                    InstabugCrashesUploaderService.this.b(crash);
                }
                catch (FileNotFoundException | JSONException throwable) {
                    InstabugSDKLogger.e((Object)((Object)InstabugCrashesUploaderService.this), (String)("Something went wrong while uploading crash attachments e: " + throwable.getMessage()));
                }
            }

            public void a(Crash crash2) {
                InstabugSDKLogger.d((Object)((Object)InstabugCrashesUploaderService.this), (String)"Something went wrong while uploading crash logs");
            }

            public /* synthetic */ void onFailed(Object object) {
                this.a((Crash)object);
            }

            public /* synthetic */ void onSucceeded(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    private void b(final Crash crash) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d((Object)((Object)this), (String)("Found " + crash.d().size() + " attachments related to crash: " + crash.c()));
        a.a().b((Context)this, crash, new Request.Callbacks<Boolean, Crash>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.d((Object)((Object)InstabugCrashesUploaderService.this), (String)"Crash attachments uploaded successfully, deleting crash");
                CrashesCacheManager.deleteCrash(crash.a());
                CrashesCacheManager.saveCacheToDisk();
                InstabugCrashesUploaderService.this.b();
            }

            public void a(Crash crash2) {
                InstabugSDKLogger.d((Object)((Object)InstabugCrashesUploaderService.this), (String)"Something went wrong while uploading crash attachments");
            }

            public /* synthetic */ void onFailed(Object object) {
                this.a((Crash)object);
            }

            public /* synthetic */ void onSucceeded(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    private void b() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        InstabugSDKLogger.v((Object)((Object)this), (String)("Updating last_crash_time to " + calendar.getTime()));
        com.instabug.crash.a.a.a().a(calendar.getTime().getTime());
    }
}

