/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.cache;

import android.support.annotation.Nullable;
import com.instabug.crash.models.Crash;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class CrashesCacheManager {
    public static final String CRASHES_DISK_CACHE_KEY = "crashes_disk_cache";
    public static final String CRASHES_MEMORY_CACHE_KEY = "crashes_memory_cache";
    public static final String CRASHES_DISK_CACHE_FILE_NAME = "/crashes.cache";

    public static InMemoryCache<String, Crash> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(CRASHES_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(CrashesCacheManager.class, (String)("In-memory Crashes cache not found, loading it from disk " + CacheManager.getInstance().getCache(CRASHES_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(CRASHES_DISK_CACHE_KEY, CRASHES_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Crash>(){

                public String a(Crash crash) {
                    return crash.a();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Crash)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(CRASHES_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(CrashesCacheManager.class, (String)("In-memory Crashes cache restored from disk, " + cache.getValues().size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(CrashesCacheManager.class, (String)"In-memory Crashes cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(CRASHES_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(CRASHES_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(CRASHES_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache, cache2, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Crash>(){

                public String a(Crash crash) {
                    return crash.a();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Crash)object);
                }
            });
        }
    }

    public static void addCrash(Crash crash) {
        InMemoryCache<String, Crash> inMemoryCache = CrashesCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)crash.a(), (Object)crash);
        }
    }

    @Nullable
    public static Crash getCrash(String string) {
        InMemoryCache<String, Crash> inMemoryCache = CrashesCacheManager.getCache();
        if (inMemoryCache != null) {
            return (Crash)inMemoryCache.get((Object)string);
        }
        return null;
    }

    public static List<Crash> getCrashes() {
        InMemoryCache<String, Crash> inMemoryCache = CrashesCacheManager.getCache();
        if (inMemoryCache != null) {
            return CrashesCacheManager.getCache().getValues();
        }
        return new ArrayList<Crash>();
    }

    @Nullable
    public static Crash deleteCrash(String string) {
        InMemoryCache<String, Crash> inMemoryCache = CrashesCacheManager.getCache();
        if (inMemoryCache != null) {
            return (Crash)CrashesCacheManager.getCache().delete((Object)string);
        }
        return null;
    }
}

