/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.instabug.crash.b.c;
import com.instabug.crash.cache.CrashesCacheManager;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.a;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.video.InstabugVideoUtils;
import com.instabug.library.model.Attachment;
import com.instabug.library.network.InstabugNetworkBasedBackgroundService;
import com.instabug.library.network.Request;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;

public class InstabugCrashesUploaderService
extends InstabugNetworkBasedBackgroundService {
    protected void runBackgroundTask() throws Exception {
        InstabugCrashesUploaderService instabugCrashesUploaderService = this;
        if (SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            int n = SettingsManager.getInstance().autoScreenRecordingMaxDuration();
            block0: for (Crash crash : CrashesCacheManager.getCrashes()) {
                if (crash.f() != Crash.CrashState.WAITING_FOR_SCREEN_RECORDING_TO_BE_TRIMMED) continue;
                Object object = crash.d().iterator();
                while (object.hasNext()) {
                    Attachment attachment = object.next();
                    if (!attachment.getType().toString().equalsIgnoreCase(Attachment.Type.AUTO_SCREEN_RECORDING.toString())) continue;
                    object = InstabugVideoUtils.startTrim((File)new File(attachment.getLocalPath()), (File)AttachmentManager.getAutoScreenRecordingFile((Context)instabugCrashesUploaderService.getApplicationContext()), (int)n);
                    object = Uri.fromFile((File)object);
                    attachment.setName(object.getLastPathSegment());
                    attachment.setLocalPath(object.getPath());
                    InstabugSDKLogger.d((Object)((Object)instabugCrashesUploaderService), (String)"auto screen recording trimmed");
                    crash.a(Crash.CrashState.READY_TO_BE_SENT);
                    continue block0;
                }
            }
        }
        this.a();
    }

    public static void a(Context context, Intent intent) {
        InstabugCrashesUploaderService.enqueueInstabugWork((Context)context, InstabugCrashesUploaderService.class, (int)2582, (Intent)intent);
    }

    private void a() throws IOException, JSONException {
        InstabugSDKLogger.d((Object)((Object)this), (String)("Found " + CrashesCacheManager.getCrashes().size() + " crashes in cache"));
        for (Crash crash : CrashesCacheManager.getCrashes()) {
            if (crash.f().equals((Object)Crash.CrashState.READY_TO_BE_SENT)) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("Uploading crash: " + crash.toString()));
                a.a().a((Context)this, crash, new Request.Callbacks<String, Throwable>(this, crash){
                    private /* synthetic */ Crash a;
                    private /* synthetic */ InstabugCrashesUploaderService b;
                    {
                        this.b = instabugCrashesUploaderService;
                        this.a = crash;
                    }

                    public final /* synthetic */ void onFailed(Object object) {
                        object = this;
                        InstabugSDKLogger.d((Object)((Object)object.b), (String)"Something went wrong while uploading crash");
                    }

                    public final /* synthetic */ void onSucceeded(Object object) {
                        String string = (String)object;
                        object = this;
                        InstabugSDKLogger.d((Object)((Object)object.b), (String)("crash uploaded successfully, setting crash TemporaryServerToken equal " + string));
                        object.a.a(string);
                        object.a.a(Crash.CrashState.LOGS_READY_TO_BE_UPLOADED);
                        CrashesCacheManager.saveCacheToDisk();
                        object.b.a(object.a);
                        InstabugCrashesUploaderService.a(object.b);
                    }
                });
                continue;
            }
            if (crash.f().equals((Object)Crash.CrashState.LOGS_READY_TO_BE_UPLOADED)) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("crash: " + crash.toString() + " already uploaded but has unsent logs, uploading now"));
                this.a(crash);
                continue;
            }
            if (!crash.f().equals((Object)Crash.CrashState.ATTACHMENTS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.d((Object)((Object)this), (String)("crash: " + crash.toString() + " already uploaded but has unsent attachments, uploading now"));
            this.b(crash);
        }
    }

    private void a(Crash crash) {
        InstabugSDKLogger.d((Object)((Object)this), (String)("START uploading all logs related to this crash id = " + crash.a()));
        a.a().c((Context)this, crash, new Request.Callbacks<Boolean, Crash>(this, crash){
            private /* synthetic */ Crash a;
            private /* synthetic */ InstabugCrashesUploaderService b;
            {
                this.b = instabugCrashesUploaderService;
                this.a = crash;
            }

            public final /* synthetic */ void onFailed(Object object) {
                object = this;
                InstabugSDKLogger.d((Object)((Object)object.b), (String)"Something went wrong while uploading crash logs");
            }

            public final /* synthetic */ void onSucceeded(Object object) {
                object = this;
                InstabugSDKLogger.d((Object)((Object)object.b), (String)"crash logs uploaded successfully, change its state");
                object.a.a(Crash.CrashState.ATTACHMENTS_READY_TO_BE_UPLOADED);
                CrashesCacheManager.saveCacheToDisk();
                try {
                    object.b.b(object.a);
                    return;
                }
                catch (FileNotFoundException | JSONException throwable) {
                    InstabugSDKLogger.e((Object)((Object)object.b), (String)("Something went wrong while uploading crash attachments e: " + throwable.getMessage()));
                    return;
                }
            }
        });
    }

    private void b(Crash crash) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d((Object)((Object)this), (String)("Found " + crash.d().size() + " attachments related to crash: " + crash.c()));
        a.a().b((Context)this, crash, new Request.Callbacks<Boolean, Crash>(this, crash){
            private /* synthetic */ Crash a;
            private /* synthetic */ InstabugCrashesUploaderService b;
            {
                this.b = instabugCrashesUploaderService;
                this.a = crash;
            }

            public final /* synthetic */ void onFailed(Object object) {
                object = this;
                InstabugSDKLogger.d((Object)((Object)object.b), (String)"Something went wrong while uploading crash attachments");
            }

            public final /* synthetic */ void onSucceeded(Object object) {
                object = this;
                InstabugSDKLogger.d((Object)((Object)object.b), (String)"Crash attachments uploaded successfully, deleting crash");
                CrashesCacheManager.deleteCrash(object.a.a());
                CrashesCacheManager.saveCacheToDisk();
                InstabugCrashesUploaderService.a(object.b);
            }
        });
    }

    static /* synthetic */ void a(InstabugCrashesUploaderService instabugCrashesUploaderService) {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        InstabugSDKLogger.v((Object)((Object)instabugCrashesUploaderService), (String)("Updating last_crash_time to " + calendar.getTime()));
        com.instabug.crash.b.a.a();
        long l = calendar.getTime().getTime();
        c.a().a(l);
    }
}

