package com.instabug.crash.nonFatals.ignorenonfatalsvalidation

import com.instabug.crash.Constants
import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.library.util.InstabugSDKLogger
import org.json.JSONObject

fun interface IgnoreNonFatalValidator {
    fun validateIgnoreNonFatalResponse(jsonObject: JSONObject, fingerPrint: JSONObject?): Boolean
}

val IgnoreNonFatalValidatorImp = IgnoreNonFatalValidator { jsonObject, fingerPrint ->
    if (!CrashesServiceLocator.crashConfigurationProvider.isIgnoreNonFatalAvailable()) {
        InstabugSDKLogger.w(Constants.LOG_TAG, "Rules are empty,invalid non fatal filtering rules")
        false
    } else {
        CrashesServiceLocator.crashConfigurationProvider
            .ignoreNonFatalList?.filter { ignoredNonFatal ->
                ignoredNonFatal.hasValidData()
            }
            ?.takeIf { it.isNotEmpty() }
            ?.any {
                with(it) {
                    validateMessageWithEmRegex(jsonObject) && validateExceptionName(jsonObject) &&
                        validateAppVersion() &&
                        validateFingerPrint(fingerPrint)
                }
            } ?: false
    }
}
