package com.instabug.commons.threading

import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.util.LimitConstraintApplier

const val FRAMES_LIMIT = 100
const val THREADS_LIMIT = 200
const val ERROR_THREAD_FRAMES_LIMIT = 200

interface ThreadingLimitsProvider {
    fun provideThreadsLimit(): Int
    fun provideFramesLimit(): Int
    fun provideErrorThreadFramesLimit(): Int
}

class ThreadingLimitsProviderImpl(
    private val limitConstraintApplier: LimitConstraintApplier
) : ThreadingLimitsProvider {

    override fun provideThreadsLimit() =
        limitConstraintApplier.applyConstraints(THREADS_LIMIT)

    override fun provideFramesLimit() =
        limitConstraintApplier.applyConstraints(FRAMES_LIMIT)

    override fun provideErrorThreadFramesLimit(): Int = limitConstraintApplier.applyConstraints(ERROR_THREAD_FRAMES_LIMIT)

}