package com.instabug.commons.preferences

import android.content.SharedPreferences
import com.instabug.library.Instabug
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.internal.sharedpreferences.PreferencesProperty
import com.instabug.library.internal.sharedpreferences.ReadWriteStrategyPreferenceProperty
import com.instabug.library.internal.sharedpreferences.WeakPreferencesProperty
import com.instabug.library.util.nullRetryLazy

typealias PrefSpec<T> = Pair<String, T>

const val IBG_CRASH_PREF_FILE = "instabug_crash"

val crashesPreferences by nullRetryLazy {
    Instabug.getApplicationContext()?.let { ctx ->
        CoreServiceLocator.getInstabugSharedPreferences(ctx, IBG_CRASH_PREF_FILE)
    }
}

class CrashPrefProperty<T>(
    key: String,
    defaultValue: T
) : PreferencesProperty<T>(key, defaultValue) {
    override val pref: SharedPreferences?
        get() = crashesPreferences
}

fun <T> crashPref(keyValue: PrefSpec<T>) =
    CrashPrefProperty(keyValue.first, keyValue.second)

class CrashWeakPrefProperty<T>(
    key: String,
    strategy: ReadWriteStrategyPreferenceProperty.ReadWriteStrategy<T?>
) : WeakPreferencesProperty<T>(key, strategy) {
    override val preference: SharedPreferences?
        get() = crashesPreferences
}

fun <T> crashWeakPref(
    key: String,
    strategy: ReadWriteStrategyPreferenceProperty.ReadWriteStrategy<T?>
) =
    CrashWeakPrefProperty(key, strategy)

object PrefSpecs {
    val ReproAttachmentsAvailability: PrefSpec<Boolean> =
        PrefSpec("crashes_rsa_availability", false)
}