package com.instabug.commons

import android.content.Context
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent

/**
 * Delegate all plugin callbacks to a separate class
 * for better code separation and testability
 */
interface PluginDelegate {

    /**
     * Gets called when the plugin is initialized
     * @param context application context
     */
    fun init(context: Context)

    /**
     * Gets called when SDK is enabled
     * @param context application context
     */
    fun start(context: Context)

    /**
     * Gets called when a new session starts
     */
    fun wake()

    /**
     * Gets called when current running session is ended
     */
    fun sleep()

    /**
     * Gets called when SDK is disabled
     */
    fun stop()

    /**
     * Gets called when a new @{link com.instabug.library.core.eventbus.coreeventbus.IBGSDKCoreEvent} is fired
     * @param sdkCoreEvent SDKCoreEvent to be handled
     */
    fun handleSDKCoreEvent(sdkCoreEvent: IBGSdkCoreEvent) {
        // No-Op
    }

}