package com.instabug.anr.model;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;

import static java.lang.annotation.RetentionPolicy.SOURCE;

@Retention(SOURCE)
@IntDef({AnrState.NOT_AVAILABLE, AnrState.READY_TO_BE_SENT, AnrState.LOGS_READY_TO_BE_UPLOADED, AnrState.ATTACHMENTS_READY_TO_BE_UPLOADED})
public @interface AnrState {

    int NOT_AVAILABLE = 0;
    int READY_TO_BE_SENT = 1;
    int LOGS_READY_TO_BE_UPLOADED = 2;
    int ATTACHMENTS_READY_TO_BE_UPLOADED = 3;
}
