package com.instabug.anr;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;

import androidx.annotation.Nullable;

import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;

import java.util.List;

public class ProcessStateHelper {

    @Nullable
    ActivityManager.ProcessErrorStateInfo getProcessErrorState() {

        ActivityManager.ProcessErrorStateInfo currentProcessErrorState = null;
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            final ActivityManager manager = (ActivityManager) context
                    .getSystemService(Activity.ACTIVITY_SERVICE);

            List<ActivityManager.ProcessErrorStateInfo> processesInError = manager.getProcessesInErrorState();
            if (processesInError != null) {
                try {
                    for (ActivityManager.ProcessErrorStateInfo state : processesInError) {
                        if (state.pid == Process.myPid()) {
                            currentProcessErrorState = state;
                        }
                    }
                } catch (Exception e){
                }
            }
        }

        return currentProcessErrorState;
    }


    String getLongMessageForAnr(ActivityManager.ProcessErrorStateInfo processInfo) {
        String anrLongMessage = "";

        if (processInfo.longMsg != null) {
            if (processInfo.longMsg.length() >= 200) {
                anrLongMessage = processInfo.longMsg.substring(0, 199);
            } else {
                anrLongMessage = processInfo.longMsg;
            }
        }

        return anrLongMessage;
    }

}
