/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.terminations.cache;

import androidx.annotation.WorkerThread;
import com.instabug.commons.caching.FileCacheDirectory;
import com.instabug.commons.caching.SessionCacheDirectory;
import com.instabug.commons.snapshot.FileKtxKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/instabug/terminations/cache/TerminationsCacheDir;", "Lcom/instabug/commons/caching/FileCacheDirectory;", "parentDir", "Lcom/instabug/commons/caching/SessionCacheDirectory;", "(Lcom/instabug/commons/caching/SessionCacheDirectory;)V", "fileDirectory", "Ljava/io/File;", "getFileDirectory", "()Ljava/io/File;", "Companion", "instabug-crash_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nTerminationsCacheDir.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminationsCacheDir.kt\ncom/instabug/terminations/cache/TerminationsCacheDir\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class TerminationsCacheDir
implements FileCacheDirectory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionCacheDirectory parentDir;

    /*
     * WARNING - void declaration
     */
    public TerminationsCacheDir(@NotNull SessionCacheDirectory parentDir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"parentDir");
        this.parentDir = var1_1;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getFileDirectory() {
        File this_ = ((TerminationsCacheDir)((Object)this_)).parentDir.getCurrentSessionDirectory();
        return this_ != null ? Companion.getTerminationsDir(this_) : null;
    }

    @Override
    @WorkerThread
    public void deleteFileDir() {
        FileCacheDirectory.DefaultImpls.deleteFileDir(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0007J\u0017\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0007J\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0007J%\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u0017J\u0015\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u0007J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u0007J\u0015\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010!\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000f\u00a2\u0006\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0014\u0010%\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010#R\u0014\u0010'\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010#R\u0014\u0010(\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010#R\u0014\u0010)\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010#R\u0014\u0010*\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010#R\u0014\u0010+\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b+\u0010#\u00a8\u0006,"}, d2={"Lcom/instabug/terminations/cache/TerminationsCacheDir$Companion;", "", "<init>", "()V", "Ljava/io/File;", "sessionDir", "getTerminationsDir", "(Ljava/io/File;)Ljava/io/File;", "", "timestamp", "getBaselineFile", "(Ljava/io/File;J)Ljava/io/File;", "getDetectedFile", "getValidatedFile", "baselineFile", "", "groundState", "", "markBaselineFileAsDetected", "(Ljava/io/File;Ljava/lang/String;J)V", "detectedFile", "stateSuffix", "markDetectedFileAsValidated", "(Ljava/io/File;Ljava/lang/String;)V", "detectionFile", "suffix", "markDetectionFileAsMigrated", "terminationDir", "getTerminationSnapshotFile", "getOldTerminationSnapshotFile", "snapshotFile", "markSnapshotFileAsOld", "(Ljava/io/File;)V", "markTerminationSnapshotFileAs", "BASELINE_FILE_SUFFIX", "Ljava/lang/String;", "DETECTED_FILE_SUFFIX", "GROUND_STATE_BG", "GROUND_STATE_FG", "MIGRATED_FILE_SUFFIX", "OLD_FILE_SUFFIX", "TERMINATIONS_DIR_NAME", "TRM_SNAPSHOT_FILE_NAME", "VALIDATED_FILE_SUFFIX", "instabug-crash_defaultUiRelease"}, xi=48)
    @SourceDebugExtension(value={"SMAP\nTerminationsCacheDir.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminationsCacheDir.kt\ncom/instabug/terminations/cache/TerminationsCacheDir$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static final boolean getBaselineFile$lambda$3(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return StringsKt.endsWith$default((String)string, (String)"-bl", (boolean)false, (int)2, null);
        }

        private static final boolean getDetectedFile$lambda$6(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return StringsKt.endsWith$default((String)string, (String)"-osd", (boolean)false, (int)2, null);
        }

        private static final boolean getValidatedFile$lambda$9(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return StringsKt.endsWith$default((String)string, (String)"-vld", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getTerminationsDir(@NotNull File sessionDir) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sessionDir, (String)"sessionDir");
            return new File(var1_1.getAbsolutePath() + File.separator + "trm");
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getBaselineFile(@NotNull File sessionDir, long timestamp) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"sessionDir");
            File this_ = ((Companion)((Object)this_)).getTerminationsDir((File)v0);
            return new File(this_.getAbsolutePath() + File.separator + (long)var2_2 + "-bl");
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final File getBaselineFile(@NotNull File sessionDir) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"sessionDir");
            Object[] this_ = this_.getTerminationsDir((File)v0);
            if (!this_.exists()) {
                this_ = null;
            }
            return this_ != null && (this_ = this_.listFiles(Companion::getBaselineFile$lambda$3)) != null ? (File)ArraysKt.firstOrNull((Object[])this_) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final File getDetectedFile(@NotNull File sessionDir) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"sessionDir");
            Object[] this_ = this_.getTerminationsDir((File)v0);
            if (!this_.exists()) {
                this_ = null;
            }
            return this_ != null && (this_ = this_.listFiles(Companion::getDetectedFile$lambda$6)) != null ? (File)ArraysKt.firstOrNull((Object[])this_) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final File getValidatedFile(@NotNull File sessionDir) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"sessionDir");
            Object[] this_ = this_.getTerminationsDir((File)v0);
            if (!this_.exists()) {
                this_ = null;
            }
            return this_ != null && (this_ = this_.listFiles(Companion::getValidatedFile$lambda$9)) != null ? (File)ArraysKt.firstOrNull((Object[])this_) : null;
        }

        /*
         * WARNING - void declaration
         */
        public final void markBaselineFileAsDetected(@NotNull File baselineFile, @NotNull String groundState, long timestamp) {
            void var3_3;
            StringBuilder stringBuilder;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"baselineFile");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"groundState");
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            FileKtxKt.rename(baselineFile, stringBuilder.append((long)var3_3).append((String)var2_2).append("-osd").toString());
        }

        /*
         * WARNING - void declaration
         */
        public final void markDetectedFileAsValidated(@NotNull File detectedFile, @NotNull String stateSuffix) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"detectedFile");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"stateSuffix");
            StringBuilder stringBuilder = new StringBuilder();
            String string = var1_1.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            FileKtxKt.rename(detectedFile, stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)((String)var2_2 + "-osd"))).append("-vld").toString());
        }

        /*
         * WARNING - void declaration
         */
        public final void markDetectionFileAsMigrated(@NotNull File detectionFile, @NotNull String suffix) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"detectionFile");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"suffix");
            StringBuilder stringBuilder = new StringBuilder();
            String string = var1_1.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            FileKtxKt.rename(detectionFile, stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)var2_2)).append("-mig").toString());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getTerminationSnapshotFile(@NotNull File terminationDir) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)terminationDir, (String)"terminationDir");
            return new File(var1_1.getAbsolutePath() + File.separator + "trm-snapshot");
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final File getOldTerminationSnapshotFile(@NotNull File terminationDir) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"terminationDir");
            File this_ = ((Companion)((Object)this_)).getTerminationSnapshotFile((File)v0);
            return new File(this_.getAbsolutePath() + "-old");
        }

        /*
         * WARNING - void declaration
         */
        public final void markSnapshotFileAsOld(@NotNull File snapshotFile) {
            void var1_1;
            File file = snapshotFile;
            Intrinsics.checkNotNullParameter((Object)file, (String)"snapshotFile");
            FileKtxKt.rename(file, var1_1.getName() + "-old");
        }

        /*
         * WARNING - void declaration
         */
        public final void markTerminationSnapshotFileAs(@NotNull File sessionDir, @NotNull String suffix) {
            void var2_2;
            Companion companion;
            Intrinsics.checkNotNullParameter((Object)companion, (String)"sessionDir");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"suffix");
            File this_ = ((Companion)((Object)this_)).getTerminationsDir((File)((Object)companion));
            companion = Companion;
            File file = companion.getTerminationSnapshotFile(this_);
            if (!file.exists()) {
                file = null;
            }
            if (!(file != null || (file = companion.getOldTerminationSnapshotFile(this_)) != null && file.exists())) {
                file = null;
            }
            if (file != null) {
                FileKtxKt.rename(file, file.getName() + (String)var2_2);
            }
        }
    }
}

