/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.fatalhangs;

import android.content.Context;
import com.instabug.commons.PluginDelegate;
import com.instabug.commons.configurations.ConfigurationsHandler;
import com.instabug.commons.logging.ExtensionsKt;
import com.instabug.fatalhangs.FatalHangsPluginDelegate;
import com.instabug.fatalhangs.configuration.FatalHangsConfigurationProvider;
import com.instabug.fatalhangs.di.FatalHangsServiceLocator;
import com.instabug.fatalhangs.model.FatalHang;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproCapturingProxy;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0002J\u001c\u0010\u001f\u001a\u00020\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020\u0013H\u0002J\b\u0010.\u001a\u00020\u0013H\u0016J\b\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020\u0013H\u0002J\b\u00101\u001a\u00020\u0013H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\b\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lcom/instabug/fatalhangs/FatalHangsPluginDelegate;", "Lcom/instabug/commons/PluginDelegate;", "()V", "configurationHandler", "Lcom/instabug/commons/configurations/ConfigurationsHandler;", "getConfigurationHandler", "()Lcom/instabug/commons/configurations/ConfigurationsHandler;", "configurationHandler$delegate", "Lkotlin/Lazy;", "configurationProvider", "Lcom/instabug/fatalhangs/configuration/FatalHangsConfigurationProvider;", "getConfigurationProvider", "()Lcom/instabug/fatalhangs/configuration/FatalHangsConfigurationProvider;", "configurationProvider$delegate", "fatalHangDetectorThread", "Ljava/lang/Thread;", "onFatalHangDetectedCallback", "Lkotlin/Function1;", "Lcom/instabug/fatalhangs/model/FatalHang;", "", "reproProxy", "Lcom/instabug/library/visualusersteps/ReproCapturingProxy;", "getReproProxy", "()Lcom/instabug/library/visualusersteps/ReproCapturingProxy;", "reproProxy$delegate", "clearCachedFatalHangs", "handleFatalHangsStateChanged", "handleFeaturesFetched", "featuresResponse", "", "handleNetworkActivated", "handleReproStateConfigurations", "modesMap", "", "", "handleSDKCoreEvent", "sdkCoreEvent", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "hasStartedActivities", "", "init", "context", "Landroid/content/Context;", "sleep", "start", "startFatalHangsDetectionIfPossible", "stop", "stopFatalHangsDetection", "syncFatalHangs", "wake", "instabug-crash_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nFatalHangsPluginDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FatalHangsPluginDelegate.kt\ncom/instabug/fatalhangs/FatalHangsPluginDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class FatalHangsPluginDelegate
implements PluginDelegate {
    @Nullable
    private Thread fatalHangDetectorThread;
    @NotNull
    private final Lazy configurationHandler$delegate = LazyKt.lazy((Function0)configurationHandler.2.INSTANCE);
    @NotNull
    private final Lazy configurationProvider$delegate = LazyKt.lazy((Function0)configurationProvider.2.INSTANCE);
    @NotNull
    private final Function1<FatalHang, Unit> onFatalHangDetectedCallback = new Function1<FatalHang, Unit>(this){
        final /* synthetic */ FatalHangsPluginDelegate this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
            super(1);
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke(@NotNull FatalHang fatalHang) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fatalHang");
            FatalHangsServiceLocator.INSTANCE.getFatalHangsCacheManager().insert((FatalHang)var1_1, Instabug.getApplicationContext());
            FatalHangsPluginDelegate.access$syncFatalHangs(this.this$0);
        }
    };
    @NotNull
    private final Lazy reproProxy$delegate = LazyKt.lazy((Function0)reproProxy.2.INSTANCE);

    private final ConfigurationsHandler getConfigurationHandler() {
        return (ConfigurationsHandler)this.configurationHandler$delegate.getValue();
    }

    private final FatalHangsConfigurationProvider getConfigurationProvider() {
        return (FatalHangsConfigurationProvider)this.configurationProvider$delegate.getValue();
    }

    private final ReproCapturingProxy getReproProxy() {
        return (ReproCapturingProxy)this.reproProxy$delegate.getValue();
    }

    private final void handleNetworkActivated() {
        if (this.getConfigurationProvider().isFatalHangsEnabled()) {
            this.syncFatalHangs();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFeaturesFetched(String featuresResponse) {
        void var1_1;
        FatalHangsPluginDelegate fatalHangsPluginDelegate = this;
        fatalHangsPluginDelegate.getConfigurationHandler().handleConfiguration((String)var1_1);
        fatalHangsPluginDelegate.handleFatalHangsStateChanged();
    }

    private final void handleFatalHangsStateChanged() {
        FatalHangsPluginDelegate fatalHangsPluginDelegate = this;
        fatalHangsPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this.getConfigurationProvider());
        if (fatalHangsPluginDelegate.getConfigurationProvider().isFatalHangsEnabled()) {
            this.startFatalHangsDetectionIfPossible();
        } else {
            FatalHangsPluginDelegate fatalHangsPluginDelegate2 = this;
            fatalHangsPluginDelegate2.stopFatalHangsDetection();
            fatalHangsPluginDelegate2.clearCachedFatalHangs();
        }
    }

    private final boolean hasStartedActivities() {
        return InstabugCore.getStartedActivitiesCount() > 0;
    }

    private final void startFatalHangsDetectionIfPossible() {
        if (this.getConfigurationProvider().isFatalHangsEnabled() && this.fatalHangDetectorThread == null && this.hasStartedActivities()) {
            Thread thread = FatalHangsServiceLocator.INSTANCE.getFatalHangDetectorThread(this.onFatalHangDetectedCallback);
            thread.start();
            this.fatalHangDetectorThread = thread;
        }
    }

    private final void syncFatalHangs() {
        String string = FatalHangsPluginDelegate.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this::class.java.name");
        synchronized (string) {
            FatalHangsServiceLocator.INSTANCE.getFatalHangsSyncManager().syncFatalHangs();
            return;
        }
    }

    private final void stopFatalHangsDetection() {
        Thread thread = this.fatalHangDetectorThread;
        if (thread != null) {
            thread.interrupt();
        }
        this.fatalHangDetectorThread = null;
    }

    private final void clearCachedFatalHangs() {
        ThreadPoolExecutor threadPoolExecutor = FatalHangsServiceLocator.INSTANCE.getIOExecutor();
        if (threadPoolExecutor != null) {
            threadPoolExecutor.execute(FatalHangsPluginDelegate::clearCachedFatalHangs$lambda$4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReproStateConfigurations(Map<Integer, Integer> modesMap) {
        void var1_1;
        FatalHangsPluginDelegate fatalHangsPluginDelegate = this;
        fatalHangsPluginDelegate.getConfigurationHandler().handle((Map)var1_1);
        fatalHangsPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this.getConfigurationProvider());
    }

    private static final void start$lambda$1(FatalHangsPluginDelegate this$0) {
        FatalHangsPluginDelegate fatalHangsPluginDelegate;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null && (settingsManager = settingsManager.getReproConfigurations()) != null) {
            fatalHangsPluginDelegate.handleReproStateConfigurations(settingsManager.getModesMap());
        }
        fatalHangsPluginDelegate.syncFatalHangs();
    }

    private static final void clearCachedFatalHangs$lambda$4() {
        FatalHangsServiceLocator fatalHangsServiceLocator = FatalHangsServiceLocator.INSTANCE;
        fatalHangsServiceLocator.getFatalHangsCacheManager().deleteAll(fatalHangsServiceLocator.getContext());
    }

    public static final /* synthetic */ void access$syncFatalHangs(FatalHangsPluginDelegate $this) {
        $this.syncFatalHangs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull Context context) {
        void var1_1;
        FatalHangsPluginDelegate fatalHangsPluginDelegate = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        fatalHangsPluginDelegate.getConfigurationHandler().migrateCurrentConfiguration();
        fatalHangsPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this.getConfigurationProvider());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        PoolProvider.postIOTaskWithCheck(() -> FatalHangsPluginDelegate.start$lambda$1(this));
    }

    @Override
    public void wake() {
        this.startFatalHangsDetectionIfPossible();
    }

    @Override
    public void sleep() {
        this.stopFatalHangsDetection();
    }

    @Override
    public void stop() {
        this.stopFatalHangsDetection();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleSDKCoreEvent(@NotNull IBGSdkCoreEvent sdkCoreEvent) {
        void var1_1;
        IBGSdkCoreEvent iBGSdkCoreEvent = sdkCoreEvent;
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent, (String)"sdkCoreEvent");
        if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.NetworkActivated.INSTANCE)) {
            ExtensionsKt.logVerbose("Fatal hangs received network activated event");
            this.handleNetworkActivated();
        } else if (var1_1 instanceof IBGSdkCoreEvent.ReproState) {
            this.handleReproStateConfigurations(((IBGSdkCoreEvent.ReproState)var1_1).getModesMap());
        } else if (var1_1 instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched(((IBGSdkCoreEvent.FeaturesFetched)var1_1).getResponse());
        } else if (var1_1 instanceof IBGSdkCoreEvent.Features) {
            this.handleFatalHangsStateChanged();
        }
    }
}

