/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.ContentValues;
import android.content.Context;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.utils.RateLimiterUtilsKt;
import com.instabug.crash.cache.CrashReportsDbHelper;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.CrashMetadataImmediateUploader;
import com.instabug.crash.network.CrashMetadataImmediateUploaderImpl;
import com.instabug.crash.network.CrashesService;
import com.instabug.crash.settings.CrashSettings;
import com.instabug.crash.utils.DeleteCrashUtilsKt;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.request.DeferredCallBack;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u001f\u001a\u00020\u0010*\u00020\u0012H\u0002J\u0014\u0010 \u001a\u00020\u0010*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/instabug/crash/network/CrashMetadataImmediateUploaderImpl;", "Lcom/instabug/crash/network/CrashMetadataImmediateUploader;", "executorService", "Ljava/util/concurrent/ExecutorService;", "context", "Landroid/content/Context;", "crashService", "Lcom/instabug/crash/network/CrashesService;", "crashSettings", "Lcom/instabug/crash/settings/CrashSettings;", "(Ljava/util/concurrent/ExecutorService;Landroid/content/Context;Lcom/instabug/crash/network/CrashesService;Lcom/instabug/crash/settings/CrashSettings;)V", "createUpdateContentValues", "Landroid/content/ContentValues;", "token", "", "handleRateLimit", "", "crash", "Lcom/instabug/crash/models/Crash;", "invoke", "Ljava/util/concurrent/Future;", "Ljava/lang/Runnable;", "notifyCrashMetadataCallback", "onImmediateCrashSent", "id", "onUploadFails", "error", "", "onUploadSucceeds", "temporaryServerToken", "upload", "cacheChanges", "update", "instabug-crash_defaultUiRelease"})
public final class CrashMetadataImmediateUploaderImpl
implements CrashMetadataImmediateUploader {
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final Context context;
    @NotNull
    private final CrashesService crashService;
    @NotNull
    private final CrashSettings crashSettings;

    /*
     * WARNING - void declaration
     */
    public CrashMetadataImmediateUploaderImpl(@NotNull ExecutorService executorService, @NotNull Context context, @NotNull CrashesService crashService, @NotNull CrashSettings crashSettings) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"crashService");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"crashSettings");
        this.executorService = var1_1;
        this.context = var2_2;
        this.crashService = var3_3;
        this.crashSettings = var4_4;
    }

    /*
     * WARNING - void declaration
     */
    private final Runnable upload(Crash crash) {
        upload.deferredCallable.1 v0;
        void var1_1;
        if (this.crashSettings.isRateLimited()) {
            return () -> CrashMetadataImmediateUploaderImpl.upload$lambda$1(this, (Crash)var1_1);
        }
        this.crashSettings.setLastRequestStartedAt(TimeUtils.currentTimeMillis());
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading crash: " + var1_1.getId() + " is handled: " + var1_1.isHandled()));
        upload.deferredCallable.1 var2_2 = v0;
        var2_2(this, (Crash)var1_1);
        this.crashService.reportCrash((Crash)var1_1, (Request.Callbacks<String, Throwable>)var2_2, false);
        DeferredCallBack.completeIfNotCompleted$default((DeferredCallBack)v0, null, (int)1, null);
        Runnable runnable = v0.get();
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"deferredCallable.get()");
        return runnable;
    }

    /*
     * WARNING - void declaration
     */
    private final void onUploadSucceeds(Crash crash, String temporaryServerToken) {
        Unit unit;
        if (temporaryServerToken != null) {
            void var1_1;
            void var2_2;
            boolean bl = RateLimiterUtilsKt.hasRateLimitedPrefix((String)var2_2);
            if (bl) {
                CrashMetadataImmediateUploaderImpl crashMetadataImmediateUploaderImpl = this;
                crashMetadataImmediateUploaderImpl.onImmediateCrashSent((Crash)var1_1, (String)var2_2);
                DeleteCrashUtilsKt.deleteCrash(crashMetadataImmediateUploaderImpl.context, (Crash)var1_1);
            } else if (!bl) {
                CrashMetadataImmediateUploaderImpl crashMetadataImmediateUploaderImpl = this;
                crashMetadataImmediateUploaderImpl.onImmediateCrashSent((Crash)var1_1, (String)var2_2);
                crashMetadataImmediateUploaderImpl.cacheChanges((Crash)var1_1);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            InstabugSDKLogger.v((String)"IBG-CR", (String)"Crash uploading response was null, aborting...");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRateLimit(Crash crash) {
        void var1_1;
        DeleteCrashUtilsKt.deleteCrash(((CrashMetadataImmediateUploaderImpl)((Object)this_)).context, (Crash)var1_1);
        String this_ = String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", Arrays.copyOf(new Object[]{"Crashes"}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"format(format, *args)");
        InstabugSDKLogger.d((String)"IBG-CR", (String)this_);
    }

    /*
     * WARNING - void declaration
     */
    private final void onUploadFails(Crash crash, Throwable error) {
        if (error instanceof RateLimitedException) {
            void var1_1;
            void var2_2;
            this.crashSettings.setLimitedUntil(((RateLimitedException)var2_2).getPeriod());
            this.handleRateLimit((Crash)var1_1);
        } else {
            InstabugSDKLogger.d((String)"IBG-CR", (String)"Something went wrong while uploading crash");
        }
    }

    private final void cacheChanges(Crash $this$cacheChanges) {
        Crash crash = $this$cacheChanges;
        String string = crash.getId();
        String string2 = crash.getTemporaryServerToken();
        if (string2 != null) {
            String string3 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"token");
            CrashReportsDbHelper.update(string, this.createUpdateContentValues(string3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ContentValues createUpdateContentValues(String token) {
        void var1_1;
        ContentValues contentValues = new ContentValues();
        contentValues.put("temporary_server_token", (String)var1_1);
        contentValues.put("crash_state", Crash.CrashState.LOGS_READY_TO_BE_UPLOADED.name());
        return contentValues;
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyCrashMetadataCallback(Crash crash) {
        void var1_1;
        CommonsLocator.getCrashMetadataCallback().onCrashSent(CommonsLocator.getCrashMetadataMapper().toMetadata((Crash)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void update(Crash $this$update, String token) {
        void var2_2;
        Crash crash = $this$update;
        crash.setTemporaryServerToken((String)var2_2);
        crash.setCrashState(Crash.CrashState.LOGS_READY_TO_BE_UPLOADED);
    }

    /*
     * WARNING - void declaration
     */
    private final void onImmediateCrashSent(Crash crash, String id) {
        void var2_2;
        void var1_1;
        CrashMetadataImmediateUploaderImpl crashMetadataImmediateUploaderImpl = this;
        crashMetadataImmediateUploaderImpl.crashSettings.setLastRequestStartedAt(0L);
        crashMetadataImmediateUploaderImpl.crashSettings.setLastCrashTime(TimeUtils.currentTimeMillis());
        InstabugSDKLogger.d((String)"IBG-CR", (String)"crash uploaded successfully");
        this.update((Crash)var1_1, (String)var2_2);
        this.notifyCrashMetadataCallback((Crash)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Runnable invoke$lambda$0(CrashMetadataImmediateUploaderImpl this$0, Crash $crash) {
        CrashMetadataImmediateUploaderImpl crashMetadataImmediateUploaderImpl;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)crashMetadataImmediateUploaderImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"$crash");
        return this$0.upload((Crash)v0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void upload$lambda$1(CrashMetadataImmediateUploaderImpl this$0, Crash $crash) {
        void var1_1;
        CrashMetadataImmediateUploaderImpl crashMetadataImmediateUploaderImpl;
        Intrinsics.checkNotNullParameter((Object)crashMetadataImmediateUploaderImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$crash");
        this$0.handleRateLimit((Crash)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onUploadSucceeds(CrashMetadataImmediateUploaderImpl $this, Crash crash, String temporaryServerToken) {
        void var2_2;
        void var1_1;
        $this.onUploadSucceeds((Crash)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onUploadFails(CrashMetadataImmediateUploaderImpl $this, Crash crash, Throwable error) {
        void var2_2;
        void var1_1;
        $this.onUploadFails((Crash)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Future<Runnable> invoke(@NotNull Crash crash) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"crash");
        Future<Runnable> future = this.executorService.submit(() -> CrashMetadataImmediateUploaderImpl.invoke$lambda$0(this, (Crash)var1_1));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executorService.submit(Callable { upload(crash) })");
        return future;
    }
}

