/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.commons.caching.DiskHelper;
import com.instabug.commons.threading.CrashDetailsParser;
import com.instabug.commons.utils.StateExtKt;
import com.instabug.crash.ImmediateSyncUncaughtExceptionHandlerDelegate;
import com.instabug.crash.ReportCreationHelper;
import com.instabug.crash.cache.CrashReportsDbHelper;
import com.instabug.crash.di.CrashesServiceLocator;
import com.instabug.crash.models.Crash;
import com.instabug.crash.settings.PerSessionSettings;
import com.instabug.crash.utils.CrashReportingUtility;
import com.instabug.early_crash.EarlyUncaughtExceptionHandlingDelegate;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

public class InstabugUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public static Boolean isRegistered = Boolean.FALSE;
    @VisibleForTesting
    public static boolean isInEarlyCapturingMode = false;
    @Nullable
    private final Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    @Nullable
    private final Context context;

    /*
     * WARNING - void declaration
     */
    public InstabugUncaughtExceptionHandler(@Nullable Context context) {
        void var1_1;
        this.context = var1_1;
        this.defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.setRegistered();
    }

    /*
     * WARNING - void declaration
     */
    public InstabugUncaughtExceptionHandler(@Nullable Context context, boolean isInEarlyCapturingMode) {
        this((Context)var1_1);
        void var1_1;
        InstabugUncaughtExceptionHandler.setEarlyCapturingMode(isInEarlyCapturingMode);
    }

    private void setRegistered() {
        isRegistered = Boolean.TRUE;
    }

    public static void setEarlyCapturingMode(boolean isInEarlyCapturingMode) {
        InstabugUncaughtExceptionHandler.isInEarlyCapturingMode = isInEarlyCapturingMode;
    }

    private boolean isIsInEarlyCapturingMode() {
        return isInEarlyCapturingMode && CrashesServiceLocator.getCrashConfigurationProvider().isCrashReportingEnabled();
    }

    private boolean isRNCrashedSession() {
        return PerSessionSettings.getInstance().isIsRNCrashedSession();
    }

    /*
     * WARNING - void declaration
     */
    public static void cacheCrash(Context context, Crash crash) {
        void var1_2;
        block4: {
            Object object;
            State state = crash.getState();
            if (state == null) break block4;
            State state2 = state;
            Context context2 = object;
            StateExtKt.updateScreenShotAnalytics(state);
            InstabugSDKLogger.v((String)"IBG-CR", (String)("caching crash " + var1_2.getId()));
            object = DiskHelper.getIncidentStateFile(var1_2.getSavingDirOnDisk((Context)object), "crash_state");
            try {
                state2.setUri(DiskUtils.with((Context)context2).writeOperation((DiskOperation)new WriteStateToFileDiskOperation((File)object, state.toJson())).execute());
            }
            catch (Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Error " + throwable.getMessage() + " while caching crash state file."));
                IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)("Error while caching fatal crash report state file: " + throwable.getMessage()));
            }
        }
        CrashReportsDbHelper.trimAndInsert((Crash)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void logOnEarlyCapturingMode(String message) {
        void var1_1;
        if (isInEarlyCapturingMode) {
            InstabugSDKLogger.w((String)"IBG-CR", (String)var1_1);
            return;
        }
        InstabugSDKLogger.d((String)"IBG-CR", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void handleEarlyException(CrashDetailsParser parser) {
        void var1_1;
        if (this.isRNCrashedSession()) {
            return;
        }
        new EarlyUncaughtExceptionHandlingDelegate.Factory().buildWithDefaults().invoke((CrashDetailsParser)var1_1, this.context);
        SettingsManager.getInstance().setCrashedSession(true);
    }

    /*
     * WARNING - void declaration
     */
    private void handleImmediateSyncCrash(CrashDetailsParser parser) {
        if (this.context != null && !this.isRNCrashedSession()) {
            void var1_1;
            new ImmediateSyncUncaughtExceptionHandlerDelegate.Factory().create().invoke((CrashDetailsParser)var1_1, this.context);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportNonFatalAndFailGracefully(Throwable throwable, String message) {
        try {
            void var2_2;
            IBGDiagnostics.reportNonFatalWithPromise((Throwable)throwable, (String)var2_2).get();
        }
        catch (Throwable throwable2) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean isImmediateMetadataSyncEnabled() {
        return CrashesServiceLocator.getCrashConfigurationProvider().isMetadataImmediateSyncAvailable();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
        block15: {
            block16: {
                InstabugSDKLogger.e((String)"IBG-CR", (String)("InstabugUncaughtExceptionHandler Caught an Unhandled Exception: " + var2_2.getClass().getCanonicalName()), (Throwable)var2_2);
                this.logOnEarlyCapturingMode("Is in early capture mode: " + InstabugUncaughtExceptionHandler.isInEarlyCapturingMode);
                if (!this.isIsInEarlyCapturingMode() && !CrashReportingUtility.isCrashReportingEnabled()) {
                    this.logOnEarlyCapturingMode("Crash reporting is disabled, skipping...");
                    this = this.defaultUncaughtExceptionHandler;
                    if (this == null) return;
                    this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
                    return;
                }
                try {
                    this.logOnEarlyCapturingMode("Creating a crash report ...");
                    var3_3 = ReportCreationHelper.parseCrashDetails((Thread)var1_1, (Throwable)var2_2);
                    if (var3_3 == null) {
                        this = this.defaultUncaughtExceptionHandler;
                        if (this == null) return;
                        this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
                        return;
                    }
                }
                catch (Throwable var3_4) {
                    break block15;
                }
                catch (OutOfMemoryError var3_5) {
                    ** GOTO lbl-1000
                }
                catch (Exception var3_6) {
                    ** GOTO lbl-1000
                }
                {
                    if (!super.isIsInEarlyCapturingMode()) ** GOTO lbl-1000
                    super.handleEarlyException((CrashDetailsParser)var3_3);
                    this = this.defaultUncaughtExceptionHandler;
                    if (this == null) return;
                    this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    if (!super.isImmediateMetadataSyncEnabled()) ** GOTO lbl-1000
                    super.handleImmediateSyncCrash((CrashDetailsParser)var3_3);
                    this = this.defaultUncaughtExceptionHandler;
                    if (this == null) return;
                    this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    ReportCreationHelper.performPreReportActivities();
                    if (this.context == null || super.isRNCrashedSession()) break block16;
                    v0 = var3_3;
                    v1 = v0;
                    v2 = v0;
                    var3_3 = ReportCreationHelper.prepareReportState(this.context);
                }
                {
                    ReportCreationHelper.modifyReportStateWithUserInput((State)var3_3);
                }
                {
                    var3_3 = new Crash.Factory().create((State)var3_3, this.context, false);
                    var4_7 = v1.getCrashDetails();
                    var5_8 = v2.getThreadsDetails();
                    var3_3 = this.updateCrash((Crash)var3_3, (JSONObject)var4_7, var5_8);
                }
                {
                    ReportCreationHelper.handleReportAttachments((Crash)var3_3, this.context);
                    InstabugUncaughtExceptionHandler.cacheCrash(this.context, (Crash)var3_3);
                    ReportCreationHelper.performPostReportActivities((Crash)var3_3);
                    super.logOnEarlyCapturingMode("Crash report created");
                    this = this.defaultUncaughtExceptionHandler;
                    if (this == null) return;
                }
lbl53:
                // 3 sources

                while (true) {
                    this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
                    return;
                }
            }
            this = this.defaultUncaughtExceptionHandler;
            if (this == null) return;
            this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
            return;
lbl-1000:
            // 1 sources

            {
                var4_7 = "OOM in uncaughtExceptionHandler";
                this.reportNonFatalAndFailGracefully(var3_5, var4_7);
                this = this.defaultUncaughtExceptionHandler;
                if (this == null) return;
                ** GOTO lbl53
            }
lbl-1000:
            // 1 sources

            {
                var4_7 = "Error while capturing crash report: " + var3_6.getMessage();
                super.reportNonFatalAndFailGracefully(var3_6, var4_7);
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Error: " + var3_6.getMessage() + " while capturing crash report"));
                this = this.defaultUncaughtExceptionHandler;
                if (this == null) return;
                ** continue;
            }
        }
        this = this.defaultUncaughtExceptionHandler;
        if (this == null) throw var3_4;
        this.uncaughtException((Thread)var1_1, (Throwable)var2_2);
        throw var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Crash updateCrash(Crash crash, JSONObject crashJsonObject, @Nullable JSONArray threadsDetails) {
        void var3_3;
        String string;
        void var1_1;
        InstabugSDKLogger.v((String)"IBG-CR", (String)"Updating crash before persisting to disk");
        Crash crash2 = var1_1.setCrashMessage(string.toString());
        string = threadsDetails != null ? var3_3.toString() : null;
        crash2.setThreadsDetails(string).setCrashState(Crash.CrashState.READY_TO_BE_SENT).setHandled(false);
        return var1_1;
    }
}

