/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.anr.network;

import android.content.ContentValues;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.anr.cache.AnrReportsDbHelper;
import com.instabug.anr.diagnostics.ANRIncidentType;
import com.instabug.anr.model.Anr;
import com.instabug.anr.network.AnrsService;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.diagnostics.di.DiagnosticsLocator;
import com.instabug.commons.diagnostics.event.CalibrationDiagnosticEvent;
import com.instabug.commons.utils.RateLimiterUtilsKt;
import com.instabug.crash.settings.CrashSettings;
import com.instabug.crash.utils.DeleteCrashUtilsKt;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.List;
import org.json.JSONException;

public class InstabugAnrUploaderJob
extends InstabugNetworkJob {
    @Nullable
    private static InstabugAnrUploaderJob INSTANCE;

    private InstabugAnrUploaderJob() {
    }

    public static synchronized InstabugAnrUploaderJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugAnrUploaderJob();
        }
        return INSTANCE;
    }

    private static void uploadAnrs(@NonNull Context context) throws JSONException {
        List<Anr> list = AnrReportsDbHelper.retrieve(context);
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Found " + list.size() + " ANRs in cache"));
        for (final Anr anr : list) {
            if (anr.getAnrState() == 1) {
                Request.Callbacks<String, Throwable> callbacks2;
                Context context2;
                if (CrashSettings.getInstance().isRateLimited()) {
                    InstabugAnrUploaderJob.deleteAnr(context2, anr);
                    InstabugAnrUploaderJob.logRateIsLimited();
                    continue;
                }
                CrashSettings.getInstance().setLastRequestStartedAt(System.currentTimeMillis());
                InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading anr: " + anr));
                Request.Callbacks<String, Throwable> callbacks3 = callbacks2;
                callbacks2 = new Request.Callbacks<String, Throwable>(){

                    /*
                     * WARNING - void declaration
                     */
                    public void onSucceeded(@Nullable String anrID) {
                        void var1_1;
                        if (anrID == null) {
                            InstabugSDKLogger.e((String)"IBG-CR", (String)"null response, aborting...");
                            return;
                        }
                        if (RateLimiterUtilsKt.hasRateLimitedPrefix((String)var1_1)) {
                            1 v0 = this_;
                            InstabugAnrUploaderJob.access$000(v0.anr, (String)var1_1);
                            InstabugAnrUploaderJob.deleteAnr(v0.context2, this_.anr);
                        } else {
                            ContentValues contentValues;
                            1 v1 = this_;
                            InstabugAnrUploaderJob.access$000(v1.anr, (String)var1_1);
                            1 this_ = contentValues;
                            new ContentValues().put("temporary_server_token", (String)var1_1);
                            this_.put("anr_upload_state", 2);
                            AnrReportsDbHelper.update(v1.anr.getId(), (ContentValues)this_);
                            InstabugAnrUploaderJob.uploadAnrLogs(v1.anr);
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onFailed(Throwable error) {
                        void var1_1;
                        if (error instanceof RateLimitedException) {
                            1 v0 = anr2;
                            Anr anr2 = v0.anr;
                            InstabugAnrUploaderJob.access$200((RateLimitedException)var1_1, anr2, v0.context2);
                        } else {
                            InstabugSDKLogger.d((String)"IBG-CR", (String)("Something went wrong while uploading ANR, " + var1_1.getMessage()));
                        }
                    }
                };
                AnrsService.getInstance().reportAnr(anr, callbacks3);
                continue;
            }
            if (anr.getAnrState() == 2) {
                InstabugSDKLogger.v((String)"IBG-CR", (String)("ANR: " + anr + " already uploaded but has unsent logs, uploading now"));
                InstabugAnrUploaderJob.uploadAnrLogs(anr);
                continue;
            }
            if (anr.getAnrState() != 3) continue;
            InstabugSDKLogger.v((String)"IBG-CR", (String)("ANR: " + anr + " already uploaded but has unsent attachments, uploading now"));
            InstabugAnrUploaderJob.uploadAnrAttachments(anr);
        }
    }

    private static void onAnrSent(Anr anr) {
        Anr anr2;
        CommonsLocator.getCrashMetadataCallback().onCrashSent(CommonsLocator.getCrashMetadataMapper().toMetadata(anr2));
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRateLimitedException(RateLimitedException exception, @NonNull Anr anr, Context context) {
        void var1_1;
        RateLimitedException rateLimitedException;
        CrashSettings.getInstance().setLimitedUntil(rateLimitedException.getPeriod());
        InstabugAnrUploaderJob.logRateIsLimited();
        InstabugAnrUploaderJob.deleteAnr(context, (Anr)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void deleteAnr(Context context, @NonNull Anr anr) {
        void var1_1;
        DeleteCrashUtilsKt.deleteAnr(context, (Anr)var1_1);
    }

    private static void logRateIsLimited() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "Crashes";
        InstabugSDKLogger.d((String)"IBG-CR", (String)String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", objectArray2));
    }

    private static void uploadAnrLogs(Anr anr) {
        Request.Callbacks<Boolean, Anr> callbacks2;
        Anr anr2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("START uploading all logs related to this ANR id = " + anr2.getId()));
        Request.Callbacks<Boolean, Anr> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<Boolean, Anr>(){

            public void onSucceeded(@Nullable Boolean isSucceeded) {
                ContentValues contentValues;
                2 v0 = this;
                2 v1 = v0;
                2 v2 = v0;
                InstabugSDKLogger.d((String)"IBG-CR", (String)"ANR logs uploaded successfully");
                v0.anr2.setAnrState(3);
                ContentValues contentValues2 = contentValues;
                try {
                    new ContentValues().put("anr_upload_state", Integer.valueOf(3));
                    AnrReportsDbHelper.update(v2.anr2.getId(), contentValues2);
                    InstabugAnrUploaderJob.uploadAnrAttachments(v1.anr2);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)("Error happened while uploading ANR: " + anr2.getId() + "attachments."));
                }
            }

            public void onFailed(Anr failedANR) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Something went wrong while uploading ANR logs");
            }
        };
        AnrsService.getInstance().uploadAnrLogs(anr2, callbacks3);
    }

    private static void uploadAnrAttachments(Anr anr) throws JSONException {
        Request.Callbacks<Boolean, Anr> callbacks2;
        Anr anr2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Found " + anr2.getAttachments().size() + " attachments related to ANR: " + anr2.getId()));
        Request.Callbacks<Boolean, Anr> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<Boolean, Anr>(){

            public void onSucceeded(@Nullable Boolean isSucceeded) {
                InstabugSDKLogger.d((String)"IBG-CR", (String)"Anr attachments uploaded successfully");
                Context context = Instabug.getApplicationContext();
                if (context != null) {
                    DeleteCrashUtilsKt.deleteAnrAndStateFile(context, anr2);
                } else {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)("unable to delete state file for ANR with id: " + anr2.getId() + "due to null context reference"));
                }
                DiagnosticsLocator.getReporter().report(new CalibrationDiagnosticEvent(new ANRIncidentType(), "synced"));
            }

            public void onFailed(Anr failedAnr) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Something went wrong while uploading ANR attachments");
            }
        };
        AnrsService.getInstance().uploadAnrAttachments(anr2, callbacks3);
    }

    /*
     * WARNING - void declaration
     */
    private static void onANRSentSetup(Anr anr, String anrID) {
        void var1_1;
        Anr anr2 = anr;
        CrashSettings.getInstance().setLastRequestStartedAt(0L);
        InstabugSDKLogger.d((String)"IBG-CR", (String)"ANR uploaded successfully");
        anr2.setTemporaryServerToken((String)var1_1);
        anr2.setAnrState(2);
        InstabugAnrUploaderJob.onAnrSent(anr2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Anr x0, String x1) {
        void var1_1;
        InstabugAnrUploaderJob.onANRSentSetup(x0, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(RateLimitedException x0, Anr x1, Context x2) {
        void var2_2;
        void var1_1;
        InstabugAnrUploaderJob.handleRateLimitedException(x0, (Anr)var1_1, (Context)var2_2);
    }

    public void start() {
        this.enqueueJob("CRASH", () -> {
            if (Instabug.getApplicationContext() != null) {
                try {
                    InstabugAnrUploaderJob.uploadAnrs(Instabug.getApplicationContext());
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)("Error " + exception.getMessage() + " occurred while uploading ANRs"), (Throwable)exception);
                }
            } else {
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't upload ANRs due to null context");
            }
        });
    }
}

