/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.anr.network;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.instabug.anr.model.Anr;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.crash.utils.DeleteCrashUtilsKt;
import com.instabug.library.Instabug;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.featuresflags.EnhancementRequestBodyParams;
import com.instabug.library.featuresflags.di.FeaturesFlagServiceLocator;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestExtKt;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class AnrsService {
    private static AnrsService INSTANCE;
    private NetworkManager networkManager;

    public AnrsService() {
        NetworkManager networkManager2;
        AnrsService this_ = networkManager2;
        networkManager2 = new NetworkManager();
        v1.networkManager = this_;
    }

    public static synchronized AnrsService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnrsService();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateReportedAtIfNeeded(Request.Builder builder, Anr anr) {
        Exception exception2;
        block4: {
            RequestParameter requestParameter;
            String string;
            long l;
            AnrsService anrsService = anr.getState();
            if (anrsService != null && !anrsService.isMinimalState() && anrsService.getReportedAt() != 0L) {
                return;
            }
            try {
                void var2_2;
                l = var2_2.getId() != null ? Long.parseLong(var2_2.getId()) : 0L;
            }
            catch (Exception exception2) {
                break block4;
            }
            if (l == 0L) return;
            void v1 = string;
            anrsService = requestParameter;
            {
                string = "reported_at";
                requestParameter = new RequestParameter(string, (Object)l);
                v1.addParameter((RequestParameter)anrsService);
            }
            return;
        }
        IBGDiagnostics.reportNonFatal((Throwable)exception2, (String)"Failed to update reported_at in anr reporting request.");
    }

    /*
     * WARNING - void declaration
     */
    public void reportAnr(Anr anr, Request.Callbacks<String, Throwable> reportingAnrCallbacks) throws JSONException {
        void var2_2;
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        void var1_1;
        AnrsService anrsService = this;
        Request request = anrsService.buildAnrReportingRequest((Anr)var1_1);
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){
            final /* synthetic */ Request.Callbacks val$reportingAnrCallbacks;
            final /* synthetic */ Anr val$anr;
            final /* synthetic */ AnrsService this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$reportingAnrCallbacks = callbacks2;
                this.val$anr = anr;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onSucceeded(RequestResponse requestResponse) {
                JSONException jSONException2;
                block4: {
                    block3: {
                        JSONObject jSONObject;
                        1 v0;
                        void var1_2;
                        InstabugSDKLogger.d((String)"IBG-CR", (String)("ReportingAnrRequest Succeeded, Response code: " + var1_2.getResponseCode()));
                        InstabugSDKLogger.v((String)"IBG-CR", (String)("ReportingAnrRequest Succeeded, Response body: " + var1_2.getResponseBody()));
                        try {
                            if (requestResponse.getResponseBody() == null) break block3;
                            v0 = this_;
                        }
                        catch (JSONException jSONException2) {
                            break block4;
                        }
                        1 this_ = jSONObject;
                        jSONObject = new JSONObject((String)var1_2.getResponseBody());
                        v0.val$reportingAnrCallbacks.onSucceeded((Object)this_.getString("id"));
                        return;
                    }
                    this_.val$reportingAnrCallbacks.onFailed((Object)new JSONException("requestResponse.getResponseBody() returned null"));
                    return;
                }
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't parse Anr request response.", (Throwable)jSONException2);
            }

            /*
             * WARNING - void declaration
             */
            public void onFailed(Throwable error) {
                void var1_1;
                if (error instanceof RateLimitedException) {
                    this.val$reportingAnrCallbacks.onFailed((Object)var1_1);
                    return;
                }
                1 v0 = this;
                InstabugSDKLogger.e((String)"IBG-CR", (String)"ReportingAnrRequest got error: ", (Throwable)var1_1);
                InstabugSDKLogger.e((String)"AnrsService", (String)"ReportingAnrRequest got error: ", (Throwable)var1_1);
                AttachmentsUtility.encryptAttachmentsAndUpdateDb(v0.val$anr.getAttachments());
                v0.val$reportingAnrCallbacks.onFailed((Object)var1_1);
            }
        };
        anrsService.networkManager.doRequestOnSameThread(1, request, (Request.Callbacks)callbacks3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @VisibleForTesting
    public Request buildAnrReportingRequest(Anr anr) {
        void var1_1;
        Object object;
        String string = Instabug.getAppToken();
        Request.Builder builder = new Request.Builder().endpoint("/crashes/anr").method("POST");
        String string2 = "IBG-APP-TOKEN";
        if (string == null) {
            string = "";
        }
        RequestParameter requestParameter = object;
        requestParameter(string2, (Object)string);
        string = builder.addHeader(requestParameter);
        RequestExtKt.getTokenFromState((Request.Builder)string, (State)var1_1.getState());
        if (var1_1.getMetadata().getUuid() != null) {
            string.addHeader(new RequestParameter("id", (Object)var1_1.getMetadata().getUuid()));
        }
        if (var1_1.getState() != null) {
            boolean bl = CommonsLocator.getConfigurationsProvider().getUserIdentificationEnabled();
            Iterator iterator = new EnhancementRequestBodyParams().getModifiedStateItemsList(var1_1.getState().getStateItems(bl), FeaturesFlagServiceLocator.getFeaturesFlagsConfigsProvider().getMode()).entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                object = (String)object2.getKey();
                string.addParameter(new RequestParameter((String)object, object2.getValue()));
            }
        }
        String string3 = string;
        this.updateReportedAtIfNeeded((Request.Builder)string, (Anr)var1_1);
        string3.addParameter(new RequestParameter("title", (Object)var1_1.getMainThreadData()));
        string3.addParameter(new RequestParameter("threads_details", (Object)var1_1.getRestOfThreadsData()));
        string3.addParameter(new RequestParameter("ANR_message", (Object)var1_1.getLongMessage()));
        string3.addParameter(new RequestParameter("anr_version", (Object)var1_1.getAnrVersion()));
        string3.addParameter(new RequestParameter("early_anr", (Object)var1_1.isEarlyAnr()));
        if (var1_1.getMetadata().getUuid() != null) {
            string.addParameter(new RequestParameter("id", (Object)var1_1.getMetadata().getUuid()));
        }
        if (var1_1.getAttachments() != null && var1_1.getAttachments().size() > 0) {
            string.addParameter(new RequestParameter("attachments_count", (Object)var1_1.getAttachments().size()));
        }
        return string.build();
    }

    /*
     * WARNING - void declaration
     */
    public void uploadAnrLogs(Anr anr, Request.Callbacks<Boolean, Anr> reportingANRLogsCallbacks) {
        void var2_2;
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        void var1_1;
        AnrsService anrsService = this;
        Request request = anrsService.buildAnrLogsRequest((Anr)var1_1);
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){
            final /* synthetic */ Request.Callbacks val$reportingANRLogsCallbacks;
            final /* synthetic */ Anr val$anr;
            final /* synthetic */ AnrsService this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$reportingANRLogsCallbacks = callbacks2;
                this.val$anr = anr;
            }

            /*
             * WARNING - void declaration
             */
            public void onSucceeded(RequestResponse response) {
                void var1_1;
                InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading ANR logs succeeded, Response code: " + var1_1.getResponseCode()));
                InstabugSDKLogger.v((String)"IBG-CR", (String)("Uploading ANR logs succeeded,, Response body: " + var1_1.getResponseBody()));
                this.val$reportingANRLogsCallbacks.onSucceeded((Object)Boolean.TRUE);
            }

            /*
             * WARNING - void declaration
             */
            public void onFailed(Throwable error) {
                void var1_1;
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Uploading ANR logs got error: " + var1_1.getMessage()));
                this.val$reportingANRLogsCallbacks.onFailed((Object)this.val$anr);
            }
        };
        anrsService.networkManager.doRequestOnSameThread(1, request, (Request.Callbacks)callbacks3);
    }

    @NonNull
    @VisibleForTesting
    public Request buildAnrLogsRequest(Anr anr) {
        Object object;
        Object object2 = ((Anr)object).getTemporaryServerToken();
        object2 = new Request.Builder().endpoint("/crashes/:crash_token/state_logs".replaceAll(":crash_token", (String)object2)).method("POST");
        RequestExtKt.getTokenFromState((Request.Builder)object2, (State)((Anr)object).getState());
        if (anr.getState() != null && (object = ((Anr)object).getState().getLogsItems()) != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Object object3 = (State.StateItem)object.next();
                if (object3.getKey() == null) continue;
                State.StateItem stateItem = object3;
                String string = stateItem.getKey();
                object3 = stateItem.getValue() != null ? object3.getValue() : "";
                RequestParameter requestParameter = new RequestParameter(string, object3);
                object2.addParameter(requestParameter);
            }
        }
        return object2.build();
    }

    /*
     * WARNING - void declaration
     */
    public void uploadAnrAttachments(Anr anr, Request.Callbacks<Boolean, Anr> anrAttachmentsCallbacks) throws JSONException {
        ArrayList arrayList;
        void var2_2;
        void var1_1;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading Anr attachments, size: " + var1_1.getAttachments().size()));
        if (anr.getAttachments().size() == 0) {
            var2_2.onSucceeded((Object)Boolean.TRUE);
            return;
        }
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (int i = 0; i < var1_1.getAttachments().size(); ++i) {
            Attachment attachment = var1_1.getAttachments().get(i);
            if (AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment)) {
                Request request = this.buildAnrSingleAttachmentRequest((Anr)var1_1, attachment);
                if (attachment.getLocalPath() != null) {
                    File file;
                    Object object = file;
                    if (new File(attachment.getLocalPath()).exists() && ((File)object).length() > 0L) {
                        Request.Callbacks<RequestResponse, Throwable> callbacks2;
                        attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
                        object = callbacks2;
                        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){
                            final /* synthetic */ Attachment val$attachment;
                            final /* synthetic */ Anr val$anr;
                            final /* synthetic */ List val$synced;
                            final /* synthetic */ Request.Callbacks val$anrAttachmentsCallbacks;
                            final /* synthetic */ AnrsService this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$attachment = attachment;
                                this.val$anr = anr;
                                this.val$synced = list;
                                this.val$anrAttachmentsCallbacks = callbacks2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onSucceeded(RequestResponse requestResponse) {
                                void var1_1;
                                InstabugSDKLogger.d((String)"IBG-CR", (String)("uploadingAnrAttachmentRequest Succeeded, Response code:" + var1_1.getResponseCode()));
                                InstabugSDKLogger.v((String)"IBG-CR", (String)("uploadingAnrAttachmentRequest Succeeded, Response body: " + var1_1.getResponseBody()));
                                if (this.val$attachment.getLocalPath() != null) {
                                    3 v0 = this;
                                    DeleteCrashUtilsKt.deleteAttachment(v0.val$attachment, this.val$anr.getId());
                                    v0.val$synced.add(this.val$attachment);
                                }
                                if (this.val$synced.size() == this.val$anr.getAttachments().size()) {
                                    this.val$anrAttachmentsCallbacks.onSucceeded((Object)Boolean.TRUE);
                                }
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onFailed(Throwable error) {
                                void var1_1;
                                InstabugSDKLogger.d((String)"IBG-CR", (String)("uploading AnrAttachment Request got error: " + var1_1.getMessage()));
                                this.val$anrAttachmentsCallbacks.onFailed((Object)this.val$anr);
                            }
                        };
                        this.networkManager.doRequestOnSameThread(2, request, (Request.Callbacks)object);
                        continue;
                    }
                    InstabugSDKLogger.e((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                    continue;
                }
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                continue;
            }
            InstabugSDKLogger.e((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it was not decrypted successfully"));
        }
    }

    @NonNull
    @VisibleForTesting
    public Request buildAnrSingleAttachmentRequest(Anr anr, Attachment attachment) throws JSONException {
        String string;
        RequestParameter requestParameter;
        Object object = requestParameter.getTemporaryServerToken();
        object = new Request.Builder().endpoint("/crashes/:crash_token/attachments".replaceAll(":crash_token", (String)object)).method("POST").type(2);
        RequestExtKt.getTokenFromState((Request.Builder)object, (State)requestParameter.getState());
        if (attachment.getType() != null) {
            RequestParameter requestParameter2;
            requestParameter = requestParameter2;
            requestParameter2 = new RequestParameter("metadata[file_type]", (Object)string.getType());
            object.addParameter(requestParameter);
        }
        if (string.getType() == Attachment.Type.AUDIO && string.getDuration() != null) {
            RequestParameter requestParameter3;
            requestParameter = requestParameter3;
            requestParameter3 = new RequestParameter("metadata[duration]", (Object)string.getDuration());
            object.addParameter(requestParameter);
        }
        if (string.getName() != null && string.getLocalPath() != null) {
            FileToUpload fileToUpload;
            requestParameter = fileToUpload;
            void v3 = string;
            string = v3.getName();
            String string2 = v3.getLocalPath();
            String string3 = v3.getFileType();
            fileToUpload = new FileToUpload("file", string, string2, string3);
            object.fileToUpload((FileToUpload)requestParameter);
        }
        return object.build();
    }
}

