package com.instabug.crash.settings;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

/**
 * Created by mohamednagy on 11/19/17.
 */

public class PerSessionSettings {

    private static PerSessionSettings perSessionSettings;

    @Nullable
    private Runnable preReportRunnable;
    private boolean isRNCrashedSession = false;

    private static void init() {
        perSessionSettings = new PerSessionSettings();
    }

    public synchronized static PerSessionSettings getInstance() {
        if (perSessionSettings == null) {
            init();
        }
        return perSessionSettings;
    }

    @Nullable
    public Runnable getPreReportRunnable() {
        return preReportRunnable;
    }

    /**
     * Set a pre-report runnable. <br/>
     * WARNING: This runs on the application's main UI thread. Please do not include any blocking operations to avoid ANRs.
     *
     * @param preReportRunnable This runnable is run on the UI thread before a crash report is uploaded to the dashboard
     */
    public void setPreReportRunnable(Runnable preReportRunnable) {
        this.preReportRunnable = preReportRunnable;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    public synchronized static void release() {
        perSessionSettings = null;
    }

    public synchronized void setRNCrashedSession(boolean isRNCrashedSession) {
        this.isRNCrashedSession = isRNCrashedSession;
    }

    public synchronized boolean isIsRNCrashedSession() {
        return isRNCrashedSession;
    }
}
