package com.instabug.crash.screenrecording;

import android.net.Uri;

import com.instabug.crash.models.Crash;
import com.instabug.library.model.Attachment;

/**
 * Created by mohamednagy on 1/21/18.
 */

public class AutoScreenRecordingUtils {

    public static void addCrashRecording(Crash crash) {
        Uri uri = ExternalAutoScreenRecordHelper.getInstance().getAutoScreenRecordingFileUri();
        if (uri != null) {
            addAttachment(crash, uri);
        }
        ExternalAutoScreenRecordHelper.getInstance().clear();
    }

    public static void addAttachment(Crash crash, Uri uri) {
        Attachment attachment = new Attachment();

        if (uri.getLastPathSegment() != null) {
            attachment.setName(uri.getLastPathSegment());
        }

        if (uri.getPath() != null) {
            attachment.setLocalPath(uri.getPath());
        }
        attachment.setType(Attachment.Type.AUTO_SCREEN_RECORDING_VIDEO);

        crash.getAttachments().add(attachment);

        crash.setCrashState(Crash.CrashState.WAITING_FOR_SCREEN_RECORDING_TO_BE_TRIMMED);
    }
}
