package com.instabug.crash.configurations

import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.library.IssueType
import com.instabug.library.ReproMode
import com.instabug.library.visualusersteps.ReproRuntimeConfigurationsHandler

class NonFatalsReproConfigurationHandler : ReproRuntimeConfigurationsHandler {

    override fun handle(modesMap: Map<Int, Int>) {
        modesMap[IssueType.NonFatal]?.let { nonFatalsMode ->
            with(CrashesServiceLocator.nonFatalsConfigurationsProvider) {
                isReproStepsEnabledSDK = nonFatalsMode > ReproMode.Disable
                isReproScreenShotsEnabledSDK = nonFatalsMode > ReproMode.EnableWithNoScreenshots
            }
        }
    }
}