package com.instabug.crash

import android.content.ContentProvider
import android.content.ContentValues
import android.content.Context
import android.content.pm.ProviderInfo
import android.database.Cursor
import android.net.Uri
import com.instabug.early_crash.di.EarlyCrashesServiceLocator.configurationsProvider
import com.instabug.early_crash.di.EarlyCrashesServiceLocator.setEarlyContext
import com.instabug.early_crash.di.EarlyCrashesServiceLocator.startupEarlyCrashUploaderJob
import com.instabug.library.core.InstabugCore
import com.instabug.library.diagnostics.customtraces.IBGPendingTraceHandler


class CrashContentProvider : ContentProvider() {
    override fun onCreate(): Boolean = true

    override fun query(
        uri: Uri,
        projection: Array<out String>?,
        selection: String?,
        selectionArgs: Array<out String>?,
        sortOrder: String?
    ): Cursor? = null

    override fun getType(uri: Uri): String? = null

    override fun insert(uri: Uri, values: ContentValues?): Uri? = null

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<out String>?): Int = -1

    override fun update(
        uri: Uri,
        values: ContentValues?,
        selection: String?,
        selectionArgs: Array<out String>?
    ): Int = -1

    override fun attachInfo(context: Context?, info: ProviderInfo?) {
        super.attachInfo(context, info)
        try {
            IBGPendingTraceHandler.crashCPStartTime = System.currentTimeMillis()
            context?.let {
                init(it)
            }
            IBGPendingTraceHandler.crashCPEndTime = System.currentTimeMillis()
        } catch (e: Exception) {
            e.printStackTrace()
        } catch (oom: OutOfMemoryError) {
            oom.printStackTrace()
        }
    }

    /**
     * Sets InstabugUncaughtExceptionHandler as DefaultUncaughtExceptionHandler
     * if last SDK state was Enabled @see [com.instabug.library.Feature.State]
     * and if early crash capture is enabled from BE
     */
    private fun init(context: Context) {
        setEarlyContext(context)
        val shouldRegisterEarlyCaptor =
            configurationsProvider.isEarlyCrashesAvailable &&
                    InstabugCore.isLastSDKStateEnabled(context)

        if (!shouldRegisterEarlyCaptor) return

        Thread.setDefaultUncaughtExceptionHandler(InstabugUncaughtExceptionHandler(context, true))
        startupEarlyCrashUploaderJob()
    }
}