package com.instabug.commons.utils

import android.app.ActivityManager
import android.app.ActivityManager.RunningAppProcessInfo
import android.content.Context
import android.os.Build
import android.os.Process
import androidx.annotation.RequiresApi

internal val Context.activityManager: ActivityManager
    get() = getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager

internal val Context.currentProcessInfo: RunningAppProcessInfo?
    get() = activityManager.runningAppProcesses
        ?.firstOrNull { process -> process.pid == Process.myPid() }

internal val Context.isProcessInForeground: Boolean
    get() = currentProcessInfo?.importance == RunningAppProcessInfo.IMPORTANCE_FOREGROUND

internal val Context.exitInfo
    @RequiresApi(Build.VERSION_CODES.R)
    get() = activityManager.getHistoricalProcessExitReasons(null, 0, 0)
