package com.instabug.commons.preferences

import android.content.SharedPreferences
import com.instabug.library.Instabug
import com.instabug.library.util.nullRetryLazy
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.internal.sharedpreferences.PreferencesProperty

typealias PrefSpec<T> = Pair<String, T>

const val IBG_CRASH_PREF_FILE = "instabug_crash"

val crashesPreferences by nullRetryLazy {
    Instabug.getApplicationContext()?.let { ctx ->
        CoreServiceLocator.getInstabugSharedPreferences(ctx, IBG_CRASH_PREF_FILE)
    }
}

class CrashPrefProperty<T>(
    key: String,
    defaultValue: T
) : PreferencesProperty<T>(key, defaultValue) {
    override val pref: SharedPreferences?
        get() = crashesPreferences
}

fun <T> crashPref(keyValue: PrefSpec<T>) = CrashPrefProperty(keyValue.first, keyValue.second)

object PrefSpecs {
    val ReproAttachmentsAvailability: PrefSpec<Boolean> =
        PrefSpec("crashes_rsa_availability", false)
}