package com.instabug.commons.caching

import com.instabug.library.SpansCacheDirectory
import com.instabug.library.model.State
import java.io.File

fun SpansCacheDirectory.getOldSpanDir(state: State): File? =
    state.appLaunchId?.takeIf { state.isEligibleForScreenshots }
        ?.let { launchId -> oldSpansDirectories.find { dir -> dir.name == launchId } }