/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.commons.threading.a;
import com.instabug.crash.configurations.c;
import com.instabug.crash.di.d;
import com.instabug.crash.eventbus.NDKCrashReportingFeatureStateChange;
import com.instabug.crash.models.IBGNonFatalException;
import com.instabug.crash.models.a;
import com.instabug.crash.network.h;
import com.instabug.crash.settings.g;
import com.instabug.crash.utils.CrashReportingUtility;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.MD5Generator;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    private static final String TAG = "CrashReporting";
    public static final String CRASH_STATE = "crash_state";
    public static final String ANR_STATE = "anr_state";

    @Deprecated
    public static void reportException(@NonNull Throwable throwable) {
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", () -> {
            Object object = IBGNonFatalException.Level.ERROR;
            CrashReporting.reportHandledException(throwable, null, null, null, (IBGNonFatalException.Level)((Object)((Object)object)));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier) {
        void var1_1;
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", () -> CrashReporting.lambda$reportException$1(throwable, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        void var1_1;
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", () -> CrashReporting.lambda$reportException$2(throwable, (String)var1_1, (Map)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier, @Nullable Map<String, String> userAttributes, @Nullable String fingerprint) {
        void var3_3;
        void var2_2;
        void var1_1;
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", () -> CrashReporting.lambda$reportException$3(throwable, (String)var1_1, (Map)var2_2, (String)var3_3));
    }

    public static void report(@NonNull IBGNonFatalException exception) {
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.report", () -> {
            Map<String, String> map;
            IBGNonFatalException iBGNonFatalException = map;
            map = iBGNonFatalException.getUserAttributes();
            String string = iBGNonFatalException.getFingerprint();
            IBGNonFatalException.Level level = iBGNonFatalException.getLevel();
            CrashReporting.reportHandledException(exception.getThrowable(), null, map, string, level);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void reportHandledException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier, @Nullable Map<String, String> userAttributes, @Nullable String fingerprint, @NonNull IBGNonFatalException.Level level) {
        void var4_4;
        void var2_2;
        void var3_3;
        JSONObject jSONObject;
        Throwable throwable2;
        if (throwable == null) {
            return;
        }
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Reporting handled exception: " + throwable2.getMessage()));
        if (!CrashReportingUtility.isCrashReportingEnabled()) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"CrashReporting is disabled, Couldn't report error");
            return;
        }
        if ((throwable2 = CrashReporting.getFormattedException(throwable2, (String)jSONObject)) == null) {
            return;
        }
        jSONObject = CrashReporting.getFingerprintObject((String)var3_3);
        if (jSONObject == null) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Grouping string not provided. This crash will be grouped by the default grouping algorithm.");
        }
        CrashReporting.reportException((JSONObject)throwable2, true, (Map<String, String>)var2_2, jSONObject, (IBGNonFatalException.Level)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled) {
        void var1_1;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        void var1_1;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, (Map<String, String>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes, @Nullable JSONObject fingerprint) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object = IBGNonFatalException.Level.ERROR;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, (Map<String, String>)var2_2, (JSONObject)var3_3, (IBGNonFatalException.Level)((Object)object));
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes, @Nullable JSONObject fingerprint, @NonNull IBGNonFatalException.Level level) {
        void var2_2;
        void var4_4;
        void var3_3;
        JSONObject jSONObject;
        void var1_1;
        if (jsonObject == null) {
            return;
        }
        if (InstabugCore.getPlatform() != 2 && var1_1 == false) {
            CrashReporting.reportCrashingSession();
        }
        if (!CrashReportingUtility.isCrashReportingEnabled()) {
            return;
        }
        if (com.instabug.crash.screenrecording.a.a().isEnabled() && SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            CrashReporting.deleteAutoScreenRecording();
        }
        PoolProvider.getSingleThreadExecutor((String)"HANDLED_CRASH").execute(() -> CrashReporting.lambda$reportException$5(jSONObject, (boolean)var1_1, (JSONObject)var3_3, (IBGNonFatalException.Level)var4_4, (Map)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier) {
        void var1_1;
        CrashReporting.createFormattedException(throwable, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating formatted exception for error: " + throwable2.getClass().getCanonicalName()));
        CrashReporting.reportException(new com.instabug.commons.threading.a(a.b.a.a, new a.a.a(throwable2, (String)var1_1)).a(), true, (Map<String, String>)var2_2);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void appendUserAttributes(@NonNull State state, Map<String, String> userAttributesMap) {
        var2_2 = 90;
        var3_3 = 100;
        var4_5 = "Instabug-CrashReporting";
        var5_6 = v0;
        v0 = new UserAttributes();
        try {
            ** if (state.getUserAttributes() == null) goto lbl-1000
        }
        catch (JSONException var6_8) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Error while appending user attributes to crash report", (Throwable)var6_8);
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = v1;
            var7_9 = new JSONObject(var0.getUserAttributes()).keys();
            while (true) {
                ** if (!var7_9.hasNext()) goto lbl22
lbl-1000:
                // 1 sources

                {
                    v2 = var5_6;
                    v3 /* !! */  = var6_7;
                    var8_10 = (String)var7_9.next();
                    v2.put(var8_10, v3 /* !! */ .getString(var8_10));
                    continue;
                }
lbl22:
                // 1 sources

                ** GOTO lbl26
                break;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
lbl26:
        // 3 sources

        if (var1_1.size() > var3_3) {
            Log.w((String)var4_5, (String)("Some old user attributes were removed. Max allowed user attributes reached. Please note that you can add up to " + var3_3 + " user attributes."));
            var6_7 = v4;
            v4 = new LinkedHashMap<K, V>(var1_1);
            var7_9 = var1_1.entrySet().iterator();
            while (var7_9.hasNext()) {
                v5 = var6_7;
                v5.remove(var7_9.next().getKey());
                if (v5.size() > var3_3) continue;
            }
            v6 = var1_1;
            v6.clear();
            v6.putAll(var6_7);
        }
        for (Object var6_7 : var1_1.entrySet()) {
            if (var1_1.get(var6_7.getKey()) == null) continue;
            if (((String)var6_7.getKey()).length() <= var2_2 && ((String)var6_7.getValue()).length() <= var2_2) {
                var5_6.put((String)var6_7.getKey(), (String)var6_7.getValue());
                continue;
            }
            Log.w((String)var4_5, (String)("Some user attributes weren't added. Max allowed user attributes characters limit is reached. Please note that you can add user attributes (key, value) with characters count up to " + var2_2 + " characters."));
        }
        var0.setUserAttributes(var5_6.toString());
    }

    private static void reportCrashingSession() {
        InstabugSDKLogger.d((String)"IBG-CR", (String)"Report crashing session");
        SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("cross_platform_crashed"));
        g.a().a(true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createStateTextFile(@NonNull Context context, @NonNull com.instabug.crash.models.a crash, @NonNull File file) {
        void var1_2;
        if (file == null) return;
        if (var1_2 == null) return;
        if (var1_2.h() == null) {
            return;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating state file for crash: " + var1_2.e()));
        try {
            void var2_3;
            Context context2;
            context2 = DiskUtils.with((Context)context2).writeOperation((DiskOperation)new WriteStateToFileDiskOperation((File)var2_3, var1_2.h().toJson())).execute();
            if (context2 != null) {
                var1_2.h().setUri((Uri)context2);
            }
            AttachmentsUtility.encryptAttachments((List)var1_2.a());
            return;
        }
        catch (Throwable throwable) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"error while creating state text file", (Throwable)throwable);
        }
    }

    public static void deleteAutoScreenRecording() {
        AutoScreenRecordingEventBus.getInstance().post((Object)ScreenRecordingService.Action.STOP_DELETE);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCrashAttachments(@NonNull Context context, com.instabug.crash.models.a crash) {
        void var1_1;
        if (context != null && var1_1 != null) {
            if (InstabugCore.getExtraAttachmentFiles() != null) {
                for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                    Context context2;
                    Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context2, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                    if (uri == null) continue;
                    var1_1.a(uri);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @VisibleForTesting
    public static JSONObject getFormattedException(@NonNull Throwable throwable, @Nullable String identifier) {
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return null;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating formatted exception for error: " + throwable2.getClass().getCanonicalName()));
        throwable2 = new com.instabug.commons.threading.a(a.b.a.a, new a.a.a(throwable2, (String)var1_1)).a();
        if (throwable2.length() == 0) {
            throwable2 = null;
        }
        return throwable2;
    }

    @Nullable
    @VisibleForTesting
    public static JSONObject getFingerprintObject(@Nullable String fingerprint) {
        block13: {
            JSONObject jSONObject;
            String string;
            block14: {
                JSONObject jSONObject2;
                String string2;
                if (fingerprint == null) {
                    return null;
                }
                if ((string = string.trim()).length() == 0) {
                    return null;
                }
                try {
                    string2 = string;
                }
                catch (Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"Failed to process fingerprint", (Throwable)throwable);
                    return null;
                }
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject();
                String string3 = MD5Generator.generateMD5((String)string2.toLowerCase());
                if (string3 == null) break block13;
                if (string3.isEmpty()) break block13;
                String string4 = string;
                JSONObject jSONObject3 = jSONObject;
                String string5 = string;
                jSONObject.put("md5", (Object)string3);
                string3 = "length";
                jSONObject3.put(string3, string5.length());
                if (string4.length() <= 40) break block14;
                InstabugSDKLogger.w((String)"IBG-CR", (String)"Grouping string exceeds the defined maximum characters limit (40) so it will be trimmed");
                string = string.substring(0, 40);
            }
            JSONObject jSONObject4 = jSONObject;
            JSONObject jSONObject5 = jSONObject4;
            jSONObject4.put("original", (Object)string);
            return jSONObject5;
        }
        throw new IllegalStateException("Couldn't generate MD5 for fingerprint");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static com.instabug.crash.models.a getCrash(JSONObject jsonObject, boolean handled, State state) {
        void var2_2;
        void var1_1;
        Object object = IBGNonFatalException.Level.ERROR;
        return CrashReporting.getCrash(jsonObject, (boolean)var1_1, (State)var2_2, null, (IBGNonFatalException.Level)((Object)object));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private static com.instabug.crash.models.a getCrash(JSONObject jsonObject, boolean handled, State state, @Nullable JSONObject fingerprint, @NonNull IBGNonFatalException.Level level) {
        void var3_3;
        void var4_4;
        void var1_1;
        Object object;
        com.instabug.crash.models.a a2;
        com.instabug.crash.models.a a3 = a2 = new a.b().a((State)a2);
        a3.a(object.toString());
        a3.a(a.a.a);
        a2.a((boolean)var1_1);
        a2.a((IBGNonFatalException.Level)var4_4);
        a2.e(new com.instabug.commons.threading.a(a.b.a.a, a.a.b.a).b().toString());
        object = fingerprint != null ? var3_3.toString() : null;
        com.instabug.crash.models.a a4 = a2;
        a4.b((String)object);
        return a4;
    }

    private static void reportUncaughtException(@NonNull JSONObject jsonObject) {
        JSONObject jSONObject;
        if (jsonObject == null) {
            return;
        }
        CrashReporting.reportException(jSONObject, false);
    }

    public static void setState(@NonNull Feature.State state) {
        VoidRunnable voidRunnable;
        Feature.State state2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("CrashReporting setState:" + state2));
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (c2.state2 == Feature.State.ENABLED && !d.b().a()) {
                    InstabugSDKLogger.e((String)"Instabug-CrashReporting", (String)"crash reporting wasn't enabled as it seems to be disabled for your Instabug company account. Please, contact support to switch it on for you.");
                    return;
                }
                a a2 = c2;
                c c2 = d.b();
                boolean bl = a2.state2 == Feature.State.ENABLED;
                c2.a(bl);
                SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("features", "updated"));
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setState", (VoidRunnable)voidRunnable2);
    }

    public static void setAnrState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (c2.state2 == Feature.State.ENABLED && !CrashReportingUtility.isCrashReportingEnabled()) {
                    InstabugSDKLogger.w((String)"IBG-CR", (String)"Can not enable ANR reporting while Crash reporting is disabled");
                    return;
                }
                b b2 = c2;
                com.instabug.anr.configuration.c c2 = com.instabug.anr.di.c.b();
                boolean bl = b2.state2 == Feature.State.ENABLED;
                c2.b(bl);
                SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("features", "updated"));
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setAnrState", (VoidRunnable)voidRunnable2);
    }

    public static void setNDKCrashesState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (NDKCrashReportingFeatureStateChange.getInstance() != null) {
                    NDKCrashReportingFeatureStateChange.getInstance().post(state2);
                } else {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't not enable NDK crash reporting state is null.");
                }
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setNDKCrashesState", (VoidRunnable)voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$reportException$5(JSONObject jsonObject, boolean isHandled, JSONObject fingerprint, IBGNonFatalException.Level level, Map userAttributes) {
        void var4_5;
        void var3_4;
        com.instabug.crash.models.a a2;
        void var1_1;
        JSONObject jSONObject;
        Context context = Instabug.getApplicationContext();
        if (context == null) {
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject = State.getState((Context)context);
        com.instabug.crash.utils.b.a((State)jSONObject);
        Report report = ReportHelper.getReport((Report.OnReportCreatedListener)InstabugCore.getOnReportCreatedListener());
        a2 = CrashReporting.getCrash(jSONObject2, (boolean)var1_1, (State)jSONObject, (JSONObject)a2, (IBGNonFatalException.Level)var3_4);
        ReportHelper.update((State)a2.h(), (Report)report);
        if (var4_5 != null && !var4_5.isEmpty()) {
            CrashReporting.appendUserAttributes((State)jSONObject, (Map<String, String>)var4_5);
        }
        if (InstabugCore.getExtraAttachmentFiles() != null && InstabugCore.getExtraAttachmentFiles().size() >= 1) {
            CrashReporting.addCrashAttachments(context, a2);
        }
        CrashReporting.createStateTextFile(context, a2, DiskUtils.createStateTextFile((Context)context, (String)CRASH_STATE));
        com.instabug.crash.cache.b.b(a2);
        com.instabug.commons.di.c.d().a(a2, 1);
        InstabugSDKLogger.d((String)"IBG-CR", (String)"Your exception has been reported");
        h.b().start();
        com.instabug.crash.screenrecording.a.a().b();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$reportException$3(Throwable throwable, String exceptionIdentifier, Map userAttributes, String fingerprint) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object = IBGNonFatalException.Level.ERROR;
        CrashReporting.reportHandledException(throwable, (String)var1_1, (Map<String, String>)var2_2, (String)var3_3, (IBGNonFatalException.Level)((Object)object));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$reportException$2(Throwable throwable, String exceptionIdentifier, Map userAttributes) throws Exception {
        void var2_2;
        void var1_1;
        Object object = IBGNonFatalException.Level.ERROR;
        CrashReporting.reportHandledException(throwable, (String)var1_1, (Map<String, String>)var2_2, null, (IBGNonFatalException.Level)((Object)object));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$reportException$1(Throwable throwable, String exceptionIdentifier) throws Exception {
        void var1_1;
        Object object = IBGNonFatalException.Level.ERROR;
        CrashReporting.reportHandledException(throwable, (String)var1_1, null, null, (IBGNonFatalException.Level)((Object)object));
    }
}

