/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.crash.b.b;
import com.instabug.crash.c.a;
import com.instabug.crash.network.InstabugCrashesUploaderService;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.analytics.AnalyticsWrapper;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    private static final String TAG = "CrashReporting";

    public static void reportException(@NonNull Throwable throwable) {
        Throwable throwable2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (throwable2 == null) {
                    return;
                }
                if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
                    return;
                }
                CrashReporting.createFormattedException(throwable2, null);
            }
        };
        APIChecker.checkAndRun((String)"CrashReporting.reportException", (VoidRunnable)voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier) {
        void var1_1;
        String string;
        JSONObject jSONObject;
        if (throwable == null) {
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        Throwable throwable2 = string;
        jSONObject2();
        string = "error";
        jSONObject.put(string, (Object)com.instabug.crash.f.b.a(throwable2, (String)var1_1));
        try {
            CrashReporting.reportException(jSONObject, true);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled) {
        JSONObject jSONObject;
        void var1_1;
        if (jsonObject == null) {
            return;
        }
        if (InstabugCore.getPlatform() != 2 && var1_1 == false) {
            CrashReporting.reportCrashingSession();
        }
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        if (com.instabug.crash.d.a.b().isEnabled() && SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            CrashReporting.deleteAutoScreenRecording();
        }
        PoolProvider.postIOTask((Runnable)new Runnable((boolean)var1_1){
            final /* synthetic */ boolean b;
            {
                this.b = bl;
            }

            @Override
            public void run() {
                Context context = Instabug.getApplicationContext();
                if (context == null) {
                    return;
                }
                State state = State.getState((Context)context);
                Report report = ReportHelper.getReport((Report.OnReportCreatedListener)InstabugCore.getOnReportCreatedListener());
                a a2 = CrashReporting.getCrash(a2.jSONObject, a2.b, state);
                ReportHelper.update((State)a2.f(), (Report)report);
                if (InstabugCore.getExtraAttachmentFiles() != null && InstabugCore.getExtraAttachmentFiles().size() >= 1) {
                    CrashReporting.addCrashAttachments(context, a2);
                }
                CrashReporting.access$000(context, a2, DiskUtils.createStateTextFile((Context)context));
                b.b(a2);
                InstabugSDKLogger.d((Object)CrashReporting.TAG, (String)"ReportCaughtException: Your exception has been reported");
                InstabugCrashesUploaderService.a(context, new Intent(context, InstabugCrashesUploaderService.class));
                com.instabug.crash.d.a.b().a();
            }
        });
    }

    private static void reportCrashingSession() {
        SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("cross_platform_crashed"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createStateTextFile(@NonNull Context context, @NonNull a crash, @NonNull File file) {
        void var1_2;
        if (file == null) return;
        if (var1_2 == null) return;
        if (var1_2.f() == null) {
            return;
        }
        try {
            void var2_3;
            Context context2;
            context2 = DiskUtils.with((Context)context2).writeOperation((DiskOperation)new WriteStateToFileDiskOperation((File)var2_3, var1_2.f().toJson())).execute();
            if (context2 != null) {
                var1_2.f().setUri((Uri)context2);
            }
            AttachmentsUtility.encryptAttachments(var1_2.a());
            return;
        }
        catch (Throwable throwable) {
            InstabugSDKLogger.e((Object)TAG, (String)"error while creating state text file", (Throwable)throwable);
        }
    }

    public static void deleteAutoScreenRecording() {
        AutoScreenRecordingEventBus.getInstance().post((Object)ScreenRecordingService.Action.STOP_DELETE);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCrashAttachments(@NonNull Context context, a crash) {
        void var1_1;
        if (context != null && var1_1 != null) {
            if (InstabugCore.getExtraAttachmentFiles() != null) {
                for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                    Context context2;
                    Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context2, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                    if (uri == null) continue;
                    var1_1.a(uri);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static a getCrash(JSONObject jsonObject, boolean handled, State state) {
        void var1_1;
        JSONObject jSONObject;
        void var2_2;
        a a2 = new a.b().a((State)var2_2);
        a2.a(jSONObject.toString());
        a2.a(a.a.READY_TO_BE_SENT);
        a2.a((boolean)var1_1);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier) {
        void var1_1;
        Throwable throwable2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            public void run() {
                if (throwable2 == null) {
                    return;
                }
                if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
                    return;
                }
                CrashReporting.createFormattedException(throwable2, this.b);
            }
        };
        APIChecker.checkAndRun((String)"CrashReporting.reportException", (VoidRunnable)voidRunnable2);
    }

    private static void reportUncaughtException(@NonNull JSONObject jsonObject) {
        JSONObject jSONObject;
        if (jsonObject == null) {
            return;
        }
        CrashReporting.reportException(jSONObject, false);
    }

    public static void setState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2);
                AnalyticsWrapper.getInstance().catchApiUsageAsync("CrashReporting.setState", parameterArray2);
                InstabugCore.setFeatureState((Feature)Feature.CRASH_REPORTING, (Feature.State)state2);
                SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("features", "updated"));
            }
        };
        APIChecker.checkAndRun((String)"CrashReporting.setState", (VoidRunnable)voidRunnable2);
    }

    public static void setAnrState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2);
                AnalyticsWrapper.getInstance().catchApiUsageAsync("CrashReporting.setAnrState", parameterArray2);
                if (state2 == Feature.State.ENABLED && InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
                    InstabugSDKLogger.w((Object)CrashReporting.TAG, (String)"Can not enable ANR reporting while Crash reporting is disabled");
                    return;
                }
                InstabugCore.setFeatureState((Feature)Feature.ANR_REPORTING, (Feature.State)state2);
                SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("features", "updated"));
            }
        };
        APIChecker.checkAndRun((String)"setAnrState", (VoidRunnable)voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Context x0, a x1, File x2) {
        void var2_2;
        void var1_1;
        CrashReporting.createStateTextFile(x0, (a)var1_1, (File)var2_2);
    }
}

