/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.session;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.i;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.filters.Filters;
import com.instabug.library.util.filters.a;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

@Keep
public class SessionLocalEntity {
    private static final String TAG = "SessionLocalEntity";
    private final long id;
    private final String os;
    private final String device;
    private final long duration;
    private final long startedAt;
    private final String userName;
    private final String userEmail;
    private final String sdkVersion;
    private final String appVersion;
    private final String userEvents;
    private final String customAttributes;
    private final String userEventsKeys;
    private final String customAttributesKeys;
    private final boolean crashReportingEnabled;
    private final int syncStatus;
    private final String uuid;
    private final String appToken;
    private final boolean usersPageEnabled;

    /*
     * WARNING - void declaration
     */
    public SessionLocalEntity(long id2, String os, String device, long duration, long startedAt, String userName, String userEmail, String sdkVersion, String appVersion, String userEvents, String customAttributes, String userEventsKeys, String customAttributesKeys, boolean crashReportingEnabled, int syncStatus, String uuid, String appToken, boolean usersPageEnabled) {
        void var21_18;
        void var20_17;
        void var19_16;
        void var18_15;
        void var17_14;
        void var16_13;
        void var15_12;
        void var14_11;
        void var13_10;
        void var12_9;
        void var11_8;
        void var10_7;
        void var9_6;
        void var7_5;
        void var5_4;
        void var4_3;
        void var3_2;
        void var1_1;
        this.id = var1_1;
        this.os = var3_2;
        this.device = var4_3;
        this.duration = var5_4;
        this.startedAt = var7_5;
        this.userName = var9_6;
        this.userEmail = var10_7;
        this.sdkVersion = var11_8;
        this.appVersion = var12_9;
        this.userEvents = var13_10;
        this.customAttributes = var14_11;
        this.userEventsKeys = var15_12;
        this.customAttributesKeys = var16_13;
        this.crashReportingEnabled = var17_14;
        this.syncStatus = var18_15;
        this.uuid = var19_16;
        this.appToken = var20_17;
        this.usersPageEnabled = var21_18;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public long getId() {
        return this.id;
    }

    public String getOs() {
        return this.os;
    }

    public String getDevice() {
        return this.device;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getUserEvents() {
        return this.userEvents;
    }

    public String getCustomAttributes() {
        return this.customAttributes;
    }

    public String getUserEventsKeys() {
        return this.userEventsKeys;
    }

    public String getCustomAttributesKeys() {
        return this.customAttributesKeys;
    }

    public boolean isCrashReportingEnabled() {
        return this.crashReportingEnabled;
    }

    public int getSyncStatus() {
        return this.syncStatus;
    }

    public boolean isUsersPageEnabled() {
        return this.usersPageEnabled;
    }

    public static class Factory {
        private boolean isCrashReportingEnabled() {
            return InstabugCore.isFeatureEnabled(Feature.CRASH_REPORTING);
        }

        private long getId() {
            return System.currentTimeMillis();
        }

        @Nullable
        private String getOs(boolean usersPageEnabled) {
            return usersPageEnabled ? "SDK Level " + InstabugDeviceProperties.getCurrentOSLevel() : null;
        }

        @Nullable
        private String getDevice(boolean usersPageEnabled) {
            return usersPageEnabled ? InstabugDeviceProperties.getDeviceType() : null;
        }

        private long getCurrentSessionTimeUntilNow() {
            long l2 = SettingsManager.getInstance().getSessionStartedAt();
            if (l2 == 0L) {
                return 0L;
            }
            return System.currentTimeMillis() / 1000L - l2;
        }

        private long getSessionStartedAt() {
            return SettingsManager.getInstance().getSessionStartedAt();
        }

        @Nullable
        private String getUserName(boolean usersPageEnabled) {
            return usersPageEnabled ? b.f() : null;
        }

        @Nullable
        private String getUserEmail(boolean usersPageEnabled) {
            return usersPageEnabled ? b.e() : null;
        }

        @NonNull
        private String getSdkVersion() {
            return "9.1.7";
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private String getAppVersion(Context context) {
            void var1_1;
            return context == null ? null : InstabugDeviceProperties.getAppVersion((Context)var1_1);
        }

        @NonNull
        private String getUserAttributesAsStringJsonObject() {
            Object object = "{}";
            HashMap<String, String> hashMap = Filters.applyOn(UserAttributesDbHelper.getAll()).apply(a.g()).thenGet();
            if (hashMap != null && hashMap.size() != 0) {
                i i2 = new i();
                i2.a(hashMap);
                object = i2.toString();
            }
            return object;
        }

        @NonNull
        private String getUserAttributesKeysAsStringJsonArray() {
            Object object = "[]";
            HashMap<String, String> hashMap = Filters.applyOn(UserAttributesDbHelper.getAll()).apply(a.g()).thenGet();
            if (hashMap != null && hashMap.size() != 0) {
                i i2 = new i();
                i2.a(hashMap);
                object = i2.c();
            }
            return object;
        }

        @NonNull
        private String getUserEventsAsStringJsonArray() {
            Object object = "[]";
            List<UserEvent> list = InstabugUserEventLogger.getInstance().getUserEvents();
            try {
                object = UserEvent.toJson(new ArrayList<UserEvent>(list)).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SessionLocalEntity.TAG, "parsing user events got error: " + jSONException.getMessage(), jSONException);
            }
            return object;
        }

        @NonNull
        private String getUserEventsKeysAsStringJsonArray() {
            List<UserEvent> list = InstabugUserEventLogger.getInstance().getUserEvents();
            return UserEvent.keysAsJsonArray(new ArrayList<UserEvent>(list)).toString();
        }

        private boolean isFirstSession() {
            return SettingsManager.getInstance().isFirstSession();
        }

        private int getSyncStatus() {
            return this.isFirstSession() ? 1 : 0;
        }

        @NonNull
        private String getUuid() {
            return b.h();
        }

        @Nullable
        private String getAppToken() {
            return Instabug.getAppToken();
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public SessionLocalEntity create(Context context, boolean usersPageEnabled) {
            String string2;
            void var2_2;
            Factory factory = string3;
            long l2 = factory.getId();
            String string3 = factory.getOs((boolean)var2_2);
            String string4 = factory.getDevice((boolean)var2_2);
            long l3 = factory.getCurrentSessionTimeUntilNow();
            long l4 = factory.getSessionStartedAt();
            String string5 = factory.getUserName((boolean)var2_2);
            String string6 = factory.getUserEmail((boolean)var2_2);
            String string7 = factory.getSdkVersion();
            string2 = factory.getAppVersion((Context)string2);
            String string8 = factory.getUserEventsAsStringJsonArray();
            String string9 = factory.getUserAttributesAsStringJsonObject();
            String string10 = factory.getUserEventsKeysAsStringJsonArray();
            String string11 = factory.getUserAttributesKeysAsStringJsonArray();
            boolean bl = factory.isCrashReportingEnabled();
            int n2 = factory.getSyncStatus();
            String string12 = factory.getUuid();
            String string13 = factory.getAppToken();
            return new SessionLocalEntity(l2, string3, string4, l3, l4, string5, string6, string7, string2, string8, string9, string10, string11, bl, n2, string12, string13, (boolean)var2_2);
        }
    }
}

