/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.instabug.library.R;

public class CircularImageView
extends ImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_FILL_COLOR = 0;
    private static final boolean DEFAULT_BORDER_OVERLAY = false;
    private final RectF mDrawableRect;
    private final RectF mBorderRect;
    private final Matrix mShaderMatrix;
    private final Paint mBitmapPaint;
    private final Paint mBorderPaint;
    private final Paint mFillPaint;
    private int mBorderColor;
    private int mBorderWidth;
    private int mFillColor;
    @Nullable
    private Bitmap mBitmap;
    @Nullable
    private BitmapShader mBitmapShader;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private float mDrawableRadius;
    private float mBorderRadius;
    @Nullable
    private ColorFilter mColorFilter;
    private boolean mReady;
    private boolean mSetupPending;
    private boolean mBorderOverlay;

    /*
     * WARNING - void declaration
     */
    public CircularImageView(Context context) {
        Paint paint;
        Paint paint2;
        Paint paint3;
        Matrix matrix;
        RectF rectF;
        RectF rectF2;
        void var1_1;
        CircularImageView circularImageView = this_;
        super((Context)var1_1);
        CircularImageView this_ = rectF2;
        rectF2 = new RectF();
        circularImageView.mDrawableRect = this_;
        this_ = rectF;
        rectF = new RectF();
        circularImageView.mBorderRect = this_;
        this_ = matrix;
        matrix = new Matrix();
        circularImageView.mShaderMatrix = this_;
        this_ = paint3;
        paint3 = new Paint();
        circularImageView.mBitmapPaint = this_;
        this_ = paint2;
        paint2 = new Paint();
        circularImageView.mBorderPaint = this_;
        this_ = paint;
        paint = new Paint();
        circularImageView.mFillPaint = this_;
        circularImageView.mBorderColor = -16777216;
        circularImageView.mBorderWidth = 0;
        circularImageView.mFillColor = 0;
        circularImageView.init();
    }

    /*
     * WARNING - void declaration
     */
    public CircularImageView(Context context, AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CircularImageView(Context context, AttributeSet attrs, int defStyle) {
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        TypedArray typedArray;
        this.mDrawableRect = new RectF();
        this.mBorderRect = new RectF();
        this.mShaderMatrix = new Matrix();
        this.mBitmapPaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mFillPaint = new Paint();
        this.mBorderColor = -16777216;
        this.mBorderWidth = 0;
        this.mFillColor = 0;
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.CircleImageView, (int)var3_3, 0);
        this.mBorderWidth = typedArray.getDimensionPixelSize(R.styleable.CircleImageView_ibg_civ_border_width, 0);
        this.mBorderColor = typedArray.getColor(R.styleable.CircleImageView_ibg_civ_border_color, -16777216);
        this.mBorderOverlay = typedArray.getBoolean(R.styleable.CircleImageView_ibg_civ_border_overlay, false);
        this.mFillColor = typedArray.getColor(R.styleable.CircleImageView_ibg_civ_fill_color, 0);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        CircularImageView circularImageView = this;
        super.setScaleType(SCALE_TYPE);
        circularImageView.mReady = true;
        if (circularImageView.mSetupPending) {
            this.setup();
            this.mSetupPending = false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap getBitmapFromDrawable(@Nullable Drawable drawable2) {
        Canvas canvas;
        void v3;
        void v2;
        CircularImageView circularImageView;
        Canvas canvas2;
        if (drawable2 == null) {
            return null;
        }
        if (canvas2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)canvas2).getBitmap();
        }
        try {
            CircularImageView circularImageView2 = canvas2 instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)canvas2.getIntrinsicWidth(), (int)canvas2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            circularImageView = circularImageView2;
            void v1 = canvas2;
            v2 = v1;
            v3 = v1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        canvas2 = canvas;
        {
            int n2 = 0;
            int n3 = 0;
            int n4 = new Canvas((Bitmap)circularImageView2).getWidth();
            int n5 = canvas2.getHeight();
            v2.setBounds(n2, n3, n4, n5);
            v3.draw(canvas2);
            return circularImageView;
        }
    }

    private void setup() {
        if (!this.mReady) {
            this.mSetupPending = true;
            return;
        }
        if (this.getWidth() == 0 && this.getHeight() == 0) {
            return;
        }
        if (this.mBitmap == null) {
            this.invalidate();
            return;
        }
        CircularImageView circularImageView = this;
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        circularImageView.mBitmapShader = new BitmapShader(this.mBitmap, tileMode, tileMode);
        circularImageView.mBitmapPaint.setAntiAlias(true);
        circularImageView.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        circularImageView.mBorderPaint.setStyle(Paint.Style.STROKE);
        circularImageView.mBorderPaint.setAntiAlias(true);
        circularImageView.mBorderPaint.setColor(this.mBorderColor);
        circularImageView.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        circularImageView.mFillPaint.setStyle(Paint.Style.FILL);
        circularImageView.mFillPaint.setAntiAlias(true);
        circularImageView.mFillPaint.setColor(this.mFillColor);
        circularImageView.mBitmapHeight = circularImageView.mBitmap.getHeight();
        circularImageView.mBitmapWidth = circularImageView.mBitmap.getWidth();
        CircularImageView circularImageView2 = this;
        float f2 = circularImageView2.getWidth();
        float f3 = circularImageView2.getHeight();
        circularImageView.mBorderRect.set(0.0f, 0.0f, f2, f3);
        circularImageView.mBorderRadius = Math.min((circularImageView.mBorderRect.height() - (float)this.mBorderWidth) / 2.0f, (this.mBorderRect.width() - (float)this.mBorderWidth) / 2.0f);
        circularImageView.mDrawableRect.set(this.mBorderRect);
        if (!circularImageView.mBorderOverlay) {
            int n2 = this.mBorderWidth;
            f2 = n2;
            this.mDrawableRect.inset(f2, (float)n2);
        }
        CircularImageView circularImageView3 = this;
        circularImageView3.mDrawableRadius = Math.min(circularImageView3.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f);
        circularImageView3.updateShaderMatrix();
        circularImageView3.invalidate();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void updateShaderMatrix() {
        float f2;
        CircularImageView circularImageView = this;
        float f3 = 0.0f;
        float f4 = 0.0f;
        circularImageView.mShaderMatrix.set(null);
        if ((float)circularImageView.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)this.mBitmapHeight) {
            CircularImageView circularImageView2 = this;
            f3 = circularImageView2.mDrawableRect.height() / (float)this.mBitmapHeight;
            f2 = (circularImageView2.mDrawableRect.width() - (float)this.mBitmapWidth * f3) * 0.5f;
            float f5 = f3;
            f3 = f4;
            f4 = f5;
        } else {
            CircularImageView circularImageView3 = this;
            f4 = circularImageView3.mDrawableRect.width() / (float)this.mBitmapWidth;
            f2 = (circularImageView3.mDrawableRect.height() - (float)this.mBitmapHeight * f4) * 0.5f;
            float f6 = f3;
            f3 = f2;
            f2 = f6;
        }
        CircularImageView circularImageView4 = this;
        float f7 = f4;
        circularImageView4.mShaderMatrix.setScale(f7, f7);
        RectF rectF = this.mDrawableRect;
        f4 = (float)((int)(f2 + 0.5f)) + rectF.left;
        circularImageView4.mShaderMatrix.postTranslate(f4, (float)((int)(f3 + 0.5f)) + rectF.top);
        rectF = circularImageView4.mBitmapShader;
        if (rectF != null) {
            rectF.setLocalMatrix(this.mShaderMatrix);
        }
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleType(ImageView.ScaleType scaleType) {
        void var1_1;
        if (scaleType == SCALE_TYPE) {
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var1_1;
        throw new IllegalArgumentException(String.format("ScaleType %s not supported.", objectArray2));
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (!adjustViewBounds) {
            return;
        }
        throw new IllegalArgumentException("adjustViewBounds not supported.");
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_2;
        Paint paint;
        float f2;
        float f3;
        float f4;
        if (this.mBitmap == null) {
            return;
        }
        if (this.mFillColor != 0) {
            CircularImageView circularImageView = this;
            f4 = (float)circularImageView.getWidth() / 2.0f;
            f3 = (float)circularImageView.getHeight() / 2.0f;
            f2 = circularImageView.mDrawableRadius;
            paint = circularImageView.mFillPaint;
            var1_2.drawCircle(f4, f3, f2, paint);
        }
        CircularImageView circularImageView = this;
        f4 = (float)circularImageView.getWidth() / 2.0f;
        f3 = (float)circularImageView.getHeight() / 2.0f;
        f2 = circularImageView.mDrawableRadius;
        paint = circularImageView.mBitmapPaint;
        var1_2.drawCircle(f4, f3, f2, paint);
        if (this.mBorderWidth != 0) {
            CircularImageView circularImageView2 = this;
            float f5 = (float)circularImageView2.getWidth() / 2.0f;
            float f6 = (float)circularImageView2.getHeight() / 2.0f;
            f4 = circularImageView2.mBorderRadius;
            Paint paint2 = circularImageView2.mBorderPaint;
            var1_2.drawCircle(f5, f6, f4, paint2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onSizeChanged(int w, int h2, int oldw, int oldh) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CircularImageView circularImageView = this;
        super.onSizeChanged((int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
        circularImageView.setup();
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderColor(@ColorInt int borderColor) {
        void var1_1;
        if (borderColor == this.mBorderColor) {
            return;
        }
        CircularImageView circularImageView = this;
        circularImageView.mBorderColor = var1_1;
        circularImageView.mBorderPaint.setColor((int)var1_1);
        circularImageView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderColorResource(@ColorRes int borderColorRes) {
        void var1_1;
        CircularImageView circularImageView = this;
        circularImageView.setBorderColor(circularImageView.getContext().getResources().getColor((int)var1_1));
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColor(@ColorInt int fillColor) {
        void var1_1;
        if (fillColor == this.mFillColor) {
            return;
        }
        CircularImageView circularImageView = this;
        circularImageView.mFillColor = var1_1;
        circularImageView.mFillPaint.setColor((int)var1_1);
        circularImageView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColorResource(@ColorRes int fillColorRes) {
        void var1_1;
        CircularImageView circularImageView = this;
        circularImageView.setFillColor(circularImageView.getContext().getResources().getColor((int)var1_1));
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderWidth(int borderWidth) {
        void var1_1;
        if (borderWidth == this.mBorderWidth) {
            return;
        }
        this.mBorderWidth = var1_1;
        this.setup();
    }

    public boolean isBorderOverlay() {
        return this.mBorderOverlay;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderOverlay(boolean borderOverlay) {
        void var1_1;
        if (borderOverlay == this.mBorderOverlay) {
            return;
        }
        this.mBorderOverlay = var1_1;
        this.setup();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageBitmap(Bitmap bm) {
        void var1_1;
        CircularImageView circularImageView = this;
        super.setImageBitmap((Bitmap)var1_1);
        circularImageView.mBitmap = var1_1;
        circularImageView.setup();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageDrawable(@Nullable Drawable drawable2) {
        void var1_1;
        CircularImageView circularImageView = this;
        super.setImageDrawable((Drawable)var1_1);
        circularImageView.mBitmap = circularImageView.getBitmapFromDrawable((Drawable)var1_1);
        circularImageView.setup();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageResource(@DrawableRes int resId) {
        void var1_1;
        CircularImageView circularImageView = this;
        super.setImageResource((int)var1_1);
        circularImageView.mBitmap = circularImageView.getBitmapFromDrawable(circularImageView.getDrawable());
        circularImageView.setup();
    }

    public void setImageURI(@Nullable Uri uri) {
        Bitmap bitmap;
        super.setImageURI((Uri)bitmap);
        if (uri != null) {
            CircularImageView circularImageView = this;
            bitmap = circularImageView.getBitmapFromDrawable(circularImageView.getDrawable());
        } else {
            bitmap = null;
        }
        this.mBitmap = bitmap;
        this.setup();
    }

    /*
     * WARNING - void declaration
     */
    public void setColorFilter(ColorFilter cf) {
        void var1_1;
        if (cf == this.mColorFilter) {
            return;
        }
        CircularImageView circularImageView = this;
        circularImageView.mColorFilter = var1_1;
        circularImageView.mBitmapPaint.setColorFilter((ColorFilter)var1_1);
        circularImageView.invalidate();
    }
}

