/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.d.a;
import com.instabug.library.invocation.d.d;
import com.instabug.library.invocation.d.f;
import com.instabug.library.invocation.d.g;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InvocationManager {
    public static final String TAG = "InvocationManager";
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private InstabugInvocationEvent[] currentInstabugInvocationEvents;
    private List<a> currentInvokers;
    @Nullable
    private a lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private boolean isInvocationAvailable;
    private com.instabug.library.invocation.b invocationRequestListenerImp;

    private InvocationManager() {
        com.instabug.library.invocation.b b2;
        ArrayList arrayList;
        InvocationSettings invocationSettings;
        InvocationManager invocationManager = this_;
        invocationManager.isInvocationAvailable = true;
        Object this_ = invocationSettings;
        invocationSettings = new InvocationSettings();
        invocationManager.currentInvocationSettings = this_;
        InstabugInvocationEvent[] instabugInvocationEventArray = new InstabugInvocationEvent[1];
        this_ = instabugInvocationEventArray;
        instabugInvocationEventArray[0] = InstabugInvocationEvent.SHAKE;
        invocationManager.currentInstabugInvocationEvents = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        invocationManager.currentInvokers = this_;
        invocationManager.subscribeToCarenActivityLifeCycle();
        this_ = b2;
        b2 = new com.instabug.library.invocation.b();
        invocationManager.invocationRequestListenerImp = this_;
    }

    public static void init() {
        InstabugSDKLogger.d(TAG, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (InstabugCore.getTargetActivity() != null) {
            INSTANCE.listen();
        }
    }

    public static InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void listen() {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && ((InvocationManager)((Object)iterator)).isInvocationAvailable && ((InvocationManager)((Object)iterator)).isPromptOptionsAvailable() && ((InvocationManager)((Object)iterator)).currentInvokers != null && InstabugCore.getTargetActivity() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            Iterator<a> iterator = ((InvocationManager)((Object)iterator)).currentInvokers.iterator();
            while (iterator.hasNext()) {
                ((a)iterator.next()).a();
            }
        }
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n2 = c.b[activityLifeCycleEvent.ordinal()];
                if (n2 != 1) {
                    if (n2 == 2) {
                        InstabugSDKLogger.d(InvocationManager.TAG, "current activity paused");
                        InvocationManager.this.sleep();
                    }
                } else {
                    InstabugSDKLogger.d(InvocationManager.TAG, "current activity resumed");
                    InvocationManager.this.listen();
                }
            }
        });
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private com.instabug.library.invocation.d.b getFloatingButtonInvoker() {
        InvocationManager invocationManager = this_;
        Object this_ = null;
        List<a> list = invocationManager.currentInvokers;
        if (list != null) {
            for (a a2 : list) {
                if (!(a2 instanceof com.instabug.library.invocation.d.b)) continue;
                this_ = (com.instabug.library.invocation.d.b)a2;
                break;
            }
        }
        return this_;
    }

    @VisibleForTesting
    public static void tearDown() {
        INSTANCE = null;
    }

    public void release() {
        Disposable disposable = this.currentActivityLifeCycleDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        this.invocationRequestListenerImp = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        void var1_1;
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates((InstabugInvocationEvent[])var1_1);
        List<a> list = invocationManager.currentInvokers;
        if (list != null) {
            list = list.iterator();
            while (list.hasNext()) {
                ((a)list.next()).b();
            }
            this.currentInvokers.clear();
        }
        int n2 = ((void)var1_1).length;
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            a<MotionEvent> a2 = var1_1[i2];
            InstabugSDKLogger.d(TAG, "set instabug invocation event: " + a2);
            if (a2 == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
                this.currentInvokers = object;
            }
            object = Instabug.getApplicationContext();
            switch (c.a[((Enum)((Object)a2)).ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    this.currentInvokers.add(new d(this.invocationRequestListenerImp));
                    continue block7;
                }
                case 3: {
                    if (object != null) {
                        g g2;
                        a2 = g2;
                        g2 = new g((Context)object, this.invocationRequestListenerImp);
                        this.currentInvokers.add(a2);
                        continue block7;
                    }
                    InstabugSDKLogger.w(TAG, "did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block7;
                }
                case 2: {
                    this.currentInvokers.add(new com.instabug.library.invocation.d.b(this.invocationRequestListenerImp));
                    continue block7;
                }
                case 1: {
                    if (object != null) {
                        f f2;
                        a2 = f2;
                        ((f)a2)((Context)object, this.invocationRequestListenerImp);
                        f2.a(this.currentInvocationSettings.getShakeThreshold());
                        this.currentInvokers.add(a2);
                        continue block7;
                    }
                    InstabugSDKLogger.w(TAG, "did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    InstabugInvocationEvent[] removeDuplicates(InstabugInvocationEvent[] events) {
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n2 = events.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            void var5_5 = var1_1[i2];
            if (hashSet2.contains(var5_5)) continue;
            arrayList2.add(var5_5);
            hashSet2.add(var5_5);
        }
        Object object = arrayList2;
        return ((ArrayList)object).toArray(new InstabugInvocationEvent[((ArrayList)object).size()]);
    }

    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        return Arrays.copyOf(this.currentInstabugInvocationEvents, this.currentInstabugInvocationEvents.length);
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<a> getCurrentInvokers() {
        return this.currentInvokers;
    }

    @Nullable
    public a getLastUsedInvoker() {
        return this.lastUsedInvoker;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastUsedInvoker(@Nullable a lastUsedInvoker) {
        void var1_1;
        this.lastUsedInvoker = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (a a2 : ((InvocationManager)this).currentInvokers) {
                void var1_1;
                if (!(a2 instanceof g)) continue;
                ((g)a2).a((MotionEvent)var1_1);
                break;
            }
        }
    }

    public void sleep() {
        Object this_ = ((InvocationManager)this_).currentInvokers;
        if (this_ != null) {
            this_ = this_.iterator();
            while (this_.hasNext()) {
                ((a)this_.next()).b();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable = false;
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable = true;
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.a.c();
    }

    public void notifyPrimaryColorChanged() {
        Object object;
        if (Instabug.isEnabled() && (object = this.currentInvokers) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                final a a2 = (a)object.next();
                if (InstabugCore.getTargetActivity() == null || !(a2 instanceof com.instabug.library.invocation.d.b)) continue;
                PoolProvider.postMainThreadTask(new Runnable(this){

                    @Override
                    public void run() {
                        b b2 = this;
                        b2.a2.b();
                        b2.a2.a();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        com.instabug.library.invocation.d.b b2 = invocationManager.getFloatingButtonInvoker();
        if (b2 != null) {
            if (bl) {
                b2.b();
            } else {
                b2.d();
            }
        }
    }

    public void show() {
        this.invocationRequestListenerImp.a();
        this.lastUsedInvoker = null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(int invocationMode) {
        void var1_1;
        this.invocationRequestListenerImp.b((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void forceInvoke(int invocationMode) {
        void var1_1;
        this.invocationRequestListenerImp.a((int)var1_1);
    }
}

