/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.model.NetworkLog;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"})
public class InstabugNetworkLog {
    public static final String TAG = "InstabugNetworkLog";
    private NetworkLog networkLog;

    public InstabugNetworkLog() {
        NetworkLog networkLog;
        NetworkLog this_ = networkLog;
        networkLog = new NetworkLog();
        v1.networkLog = this_;
    }

    /*
     * WARNING - void declaration
     */
    private String validateBody(String responseBody) {
        void var1_1;
        if (responseBody == null) {
            return null;
        }
        if ((long)var1_1.getBytes(Charset.forName("UTF-8")).length > 1000000L) {
            return "{\"InstabugNetworkLog Error\":\"Response body exceeded limit\"}";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void addHeaders(HttpURLConnection connection) throws JSONException, IllegalArgumentException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        for (String string2 : connection.getHeaderFields().keySet()) {
            void var1_1;
            if (string2 == null) continue;
            for (String string3 : var1_1.getHeaderFields().get(string2)) {
                if (!(!string2.equalsIgnoreCase("content-type") || string3.contains("application/json") || string3.contains("application/xml") || string3.contains("text/xml") || string3.contains("application/protobuf") || string3.contains("text/html") || string3.contains("text/plain"))) {
                    throw new IllegalArgumentException();
                }
                jSONObject2.put(string2, (Object)string3);
            }
        }
        this.networkLog.setRequestHeaders(jSONObject2.toString());
    }

    private void insert() {
        this.networkLog.insert();
    }

    /*
     * WARNING - void declaration
     */
    public void log(String url, String method, String requestBody, String responseBody, int responseCode) throws IOException {
        void var1_1;
        void var2_2;
        void var5_5;
        InstabugNetworkLog instabugNetworkLog = this;
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("connection").setType(HttpURLConnection.class), new Api.Parameter().setName("requestBody").setType(String.class), new Api.Parameter().setName("responseBody").setType(String.class));
        instabugNetworkLog.networkLog.setResponseCode((int)var5_5);
        instabugNetworkLog.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        instabugNetworkLog.networkLog.setMethod((String)var2_2);
        instabugNetworkLog.networkLog.setUrl((String)var1_1);
        try {
            void var4_4;
            void var3_3;
            instabugNetworkLog.networkLog.setRequest(this.validateBody((String)var3_3));
            instabugNetworkLog.networkLog.setResponse(this.validateBody((String)var4_4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(TAG, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        instabugNetworkLog.insert();
        InstabugSDKLogger.d(TAG, "adding network log: " + this.networkLog.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void log(HttpURLConnection connection, String requestBody, String responseBody) throws IOException {
        void var1_1;
        InstabugNetworkLog instabugNetworkLog = this;
        InstabugNetworkLog instabugNetworkLog2 = this;
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("connection").setType(HttpURLConnection.class), new Api.Parameter().setName("requestBody").setType(String.class), new Api.Parameter().setName("responseBody").setType(String.class));
        instabugNetworkLog2.networkLog.setResponseCode(var1_1.getResponseCode());
        instabugNetworkLog2.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        instabugNetworkLog2.networkLog.setMethod(var1_1.getRequestMethod());
        instabugNetworkLog2.networkLog.setUrl(var1_1.getURL().toString());
        try {
            void var3_3;
            void var2_2;
            instabugNetworkLog.addHeaders((HttpURLConnection)var1_1);
            instabugNetworkLog.networkLog.setRequest(this.validateBody((String)var2_2));
            instabugNetworkLog.networkLog.setResponse(this.validateBody((String)var3_3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(TAG, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.insert();
        InstabugSDKLogger.d(TAG, "adding network log: " + this.networkLog.toString());
    }
}

