/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import androidx.annotation.Keep;
import java.util.concurrent.TimeUnit;

@Keep
public final class TimeUtils {
    public static final long DAY_MILLIS = TimeUnit.DAYS.toMillis(1L);

    private TimeUtils() {
    }

    public static long monthToMillis(int month) {
        return TimeUnit.DAYS.toMillis((long)month * 30L);
    }

    public static long monthToHours(int month) {
        return TimeUnit.DAYS.toHours((long)month * 30L);
    }

    public static long monthToDays(int month) {
        return TimeUnit.DAYS.toDays((long)month * 30L);
    }

    public static long elapsedTimeMillis(long since, long until, TimeUnit timeUnit) {
        since = timeUnit.toMillis(since);
        return timeUnit.toMillis(until) - since;
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }
}

