/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import androidx.annotation.IntRange;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.List;

public class StringUtility {
    public static final String ELLIPSIZE = "\u2026";
    private static final String TAG = "StringUtility";

    public static String trimString(String s) {
        return StringUtility.trimString(s, 4096);
    }

    /*
     * WARNING - void declaration
     */
    public static String trimString(String s, int limit) {
        void var1_1;
        String string2;
        if (s == null) {
            return "null";
        }
        if (string2.length() > var1_1) {
            string2 = string2.substring(0, (int)var1_1);
            InstabugSDKLogger.i(TAG, "trimming string to " + (int)var1_1);
        }
        return string2;
    }

    public static String[] trimStrings(String[] strings) {
        String[] stringArray;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = StringUtility.trimString(stringArray[i2]);
        }
        return stringArray;
    }

    public static boolean isNumeric(String s) {
        return s.matches("\\d+(?:\\.\\d+)?");
    }

    /*
     * WARNING - void declaration
     */
    public static int compareVersion(String version1, String version2) throws NumberFormatException {
        version1 = version1.split("\\.");
        version2 = version2.split("\\.");
        int n = 0;
        void var1_1;
        String string2;
        while (n < ((String)string2).length || n < ((void)var1_1).length) {
            if (n < ((String)string2).length && n < ((void)var1_1).length) {
                if (Integer.parseInt(string2[n]) < Integer.parseInt((String)var1_1[n])) {
                    return -1;
                }
                if (Integer.parseInt(string2[n]) > Integer.parseInt((String)var1_1[n])) {
                    return 1;
                }
            } else if (n < ((String)string2).length) {
                if (Integer.parseInt(string2[n]) != 0) {
                    return 1;
                }
            } else if (n < ((void)var1_1).length && Integer.parseInt((String)var1_1[n]) != 0) {
                return -1;
            }
            ++n;
        }
        return 0;
    }

    public static String removeExtension(String fileName) {
        return fileName.replaceFirst("[.][^.]+$", "");
    }

    public static String toCommaSeparated(List<String> strings) {
        List<String> list;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (strings != null && list.size() != 0) {
            for (int i2 = 0; i2 < list.size() - 1; ++i2) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(list.get(i2));
                stringBuilder3.append(",");
            }
            StringBuilder stringBuilder4 = stringBuilder2;
            List<String> list2 = list;
            stringBuilder4.append(list2.get(list2.size() - 1));
            return stringBuilder4.toString();
        }
        return stringBuilder2.toString();
    }

    public static String applyDoubleQuotations(String s) {
        String string2;
        if (s != null && string2.trim().length() != 0) {
            if (!string2.startsWith("\"")) {
                string2 = "\"" + string2 + "\"";
            }
            return string2;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static String ellipsize(String str, @IntRange(from=0L) int limit) {
        void var1_1;
        String string2;
        if (str != null && string2.trim().length() > var1_1) {
            string2 = string2.trim().substring(0, (int)var1_1) + ELLIPSIZE;
        }
        return string2;
    }
}

