/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class InstabugDeprecationLogger {
    private static final String PREFIX_SECTION = "#section-";
    @VisibleForTesting
    static String baseUrl = "https://docs.instabug.com/docs/android-sdk-8-6-migration-guide";
    private static InstabugDeprecationLogger INSTANCE;

    private InstabugDeprecationLogger() {
    }

    public static InstabugDeprecationLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugDeprecationLogger();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    static void tearDown() {
        INSTANCE = null;
    }

    private static void setBaseUrl(String baseUrl) {
        String string2;
        if (baseUrl != null && string2.trim().length() > 0) {
            InstabugDeprecationLogger.baseUrl = string2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getSection(int section) {
        if (section != 18) {
            void var1_1;
            if (var1_1 != 19) {
                return "";
            }
            return "setstate";
        }
        return "show";
    }

    /*
     * WARNING - void declaration
     */
    public void log(int section) {
        void var1_1;
        Context context;
        if (Instabug.isBuilt() && Instabug.isEnabled() && (context = Instabug.getApplicationContext()) != null && (context.getApplicationInfo().flags & 2) != 0 && (var1_1 == 19 || var1_1 == 18)) {
            Log.i((String)"INSTABUG", (String)("\n\nIn this release, we\u2019re improving the in-app communication experience. Now, your end user will have a unified experience while sending you a report independently from its type. Whether it is a bug, improvement, or question, they\u2019ll see the same experience.\n\nThe Chats class and its methods have been deprecated, and while they still function, they will be completely removed in a future release. For more details about this API\u2019s replacement, check the docs here: " + this.getMigrationPageUrl((int)var1_1) + ".\n\nIf you have any questions please reach out to us through contactus@instabug.com."));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message) {
        if (Instabug.isBuilt() && Instabug.isEnabled() && (this = Instabug.getApplicationContext()) != null && (this.getApplicationInfo().flags & 2) != 0) {
            void var1_1;
            Log.i((String)"INSTABUG", (String)var1_1);
        }
    }

    @VisibleForTesting
    String getMigrationPageUrl() {
        return baseUrl;
    }

    @VisibleForTesting
    String getMigrationPageUrl(int section) {
        return baseUrl + PREFIX_SECTION + this.getSection(section);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MigrationSection {
        public static final int METHOD_SHOW_CHATS = 18;
        public static final int METHOD_SET_CHATS_STATE = 19;
    }
}

