/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.orchestrator;

import androidx.annotation.NonNull;
import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public final class ActionsOrchestrator {
    public static final String TAG = "ActionsOrchestrator";
    private final List<Action> sameThreadActions;
    private final List<Action> workerThreadActions;
    private final Executor backgroundExecutor;

    private ActionsOrchestrator(Executor backgroundExecutor) {
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.backgroundExecutor = backgroundExecutor;
        actionsOrchestrator.sameThreadActions = new ArrayList<Action>();
        actionsOrchestrator.workerThreadActions = new ArrayList<Action>();
    }

    public static ActionsOrchestrator obtainOrchestrator() {
        return new ActionsOrchestrator(PoolProvider.newBackgroundExecutor());
    }

    public static ActionsOrchestrator obtainOrchestrator(@NonNull Executor workerThreadExecutor) {
        return new ActionsOrchestrator(workerThreadExecutor);
    }

    private void orchestrateSameThreadActions() {
        Iterator<Action> iterator = this.sameThreadActions.iterator();
        while (iterator.hasNext()) {
            this.runAction(iterator.next());
        }
    }

    private void orchestrateWorkerThreadActions() {
        PoolProvider.postTask(this.backgroundExecutor, new Runnable(){

            @Override
            public void run() {
                for (Action action : ActionsOrchestrator.this.workerThreadActions) {
                    ActionsOrchestrator.this.runAction(action);
                }
            }
        });
    }

    private void runAction(Action action) {
        InstabugSDKLogger.d(TAG, "runAction");
        try {
            action.run();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            InstabugSDKLogger.e(TAG, exception.getMessage(), exception2);
        }
    }

    public ActionsOrchestrator addSameThreadAction(@NonNull Action action) {
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.sameThreadActions.add(action);
        return actionsOrchestrator;
    }

    public ActionsOrchestrator addWorkerThreadAction(@NonNull Action action) {
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.workerThreadActions.add(action);
        return actionsOrchestrator;
    }

    public void orchestrate() {
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.orchestrateSameThreadActions();
        actionsOrchestrator.orchestrateWorkerThreadActions();
    }
}

