/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.instabug.library.util.InstabugSDKLogger;

public class PermissionsUtils {
    public static final String TAG = "PermissionUtils";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String permission) {
        try {
            StringBuilder stringBuilder;
            Context context2;
            if (Build.VERSION.SDK_INT >= 23) {
                boolean bl = ContextCompat.checkSelfPermission((Context)context2, (String)((Object)stringBuilder)) == 0;
                String string2 = TAG;
                stringBuilder = new StringBuilder().append("Permission ").append((String)((Object)stringBuilder)).append(" state is ");
                String string3 = bl ? "" : "NOT ";
                InstabugSDKLogger.d(string2, stringBuilder.append(string3).append("granted").toString());
                return bl;
            }
            boolean bl = context2.checkCallingOrSelfPermission((String)((Object)stringBuilder)) == 0;
            String string4 = TAG;
            stringBuilder = new StringBuilder().append("Permission ").append((String)((Object)stringBuilder)).append(" state is ");
            String string5 = bl ? "" : "NOT ";
            InstabugSDKLogger.d(string4, stringBuilder.append(string5).append("granted").toString());
            return bl;
        }
        catch (Error error) {
            return true;
        }
        catch (Exception exception) {}
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void requestPermission(@NonNull Activity activity, @NonNull String permission, int requestCode, @Nullable Runnable onShouldNotShowPermissionRationale, @Nullable Runnable afterPermissionGrantedRunnable) {
        void var1_1;
        if (!PermissionsUtils.isPermissionGranted((Context)activity, permission)) {
            void var2_2;
            Activity activity2;
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity2, (String)var1_1)) {
                void var3_3;
                PermissionsUtils.runIfValid((Runnable)var3_3);
            }
            InstabugSDKLogger.d(TAG, "Permission " + (String)var1_1 + " not granted, requesting it");
            ActivityCompat.requestPermissions((Activity)activity2, (String[])new String[]{var1_1}, (int)var2_2);
        } else {
            void var4_4;
            InstabugSDKLogger.d(TAG, "Permission " + (String)var1_1 + " already granted, running after permission granted runnable");
            PermissionsUtils.runIfValid((Runnable)var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void requestPermission(Fragment fragment, String permission, int requestCode, @Nullable Runnable onShouldNotShowPermissionRationale, Runnable afterPermissionGrantedRunnable) {
        void var1_1;
        if (!PermissionsUtils.isPermissionGranted(fragment.getContext(), permission)) {
            void var2_2;
            Fragment fragment2;
            if (!fragment2.shouldShowRequestPermissionRationale((String)var1_1)) {
                void var3_3;
                PermissionsUtils.runIfValid((Runnable)var3_3);
            }
            InstabugSDKLogger.d(TAG, "Permission " + (String)var1_1 + " not granted, requesting it");
            fragment2.requestPermissions(new String[]{var1_1}, (int)var2_2);
        } else {
            void var4_4;
            InstabugSDKLogger.d(TAG, "Permission " + (String)var1_1 + " already granted, running after permission granted runnable");
            PermissionsUtils.runIfValid((Runnable)var4_4);
        }
    }

    private static void runIfValid(Runnable runnable) {
        if (runnable != null) {
            Runnable runnable2;
            runnable2.run();
        }
    }
}

