/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.annotation;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.annotation.AnnotationView;
import com.instabug.library.annotation.ColorPickerPopUpView;
import com.instabug.library.annotation.ShapeSuggestionsLayout;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.view.IconView;
import com.instabug.library.view.ViewUtils;
import java.io.Serializable;

public class AnnotationLayout
extends LinearLayout
implements View.OnClickListener {
    private static final String ANNOTATION_LAYOUT = "instabug_annotation_layout";
    private static final String DRAWING_MODE = "drawingMode";
    private AnnotationView annotationView;
    private ColorPickerPopUpView colorPicker;
    private int tintingColor;
    private LinearLayout annotationActionsContainer;
    private RelativeLayout iconBrushLayout;
    private ImageView iconBrush;
    private ImageView iconMagnify;
    private ImageView iconBlur;
    private ImageView iconUndo;
    private View brushIndicator;
    private View border;
    private ShapeSuggestionsLayout shapeSuggestionsLayout;

    public AnnotationLayout(Context context) {
        this(context, null);
    }

    public AnnotationLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @TargetApi(value=11)
    public AnnotationLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        AnnotationLayout annotationLayout = this;
        super(context, attrs, defStyleAttr);
        annotationLayout.initViews();
    }

    @TargetApi(value=21)
    public AnnotationLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        AnnotationLayout annotationLayout = this;
        super(context, attrs, defStyleAttr, defStyleRes);
        annotationLayout.initViews();
    }

    private void initViews() {
        AnnotationLayout annotationLayout = this;
        LinearLayout.inflate((Context)annotationLayout.getContext(), (int)R.layout.instabug_annotation_view, (ViewGroup)this);
        annotationLayout.annotationActionsContainer = (LinearLayout)annotationLayout.findViewById(R.id.instabug_annotation_actions_container);
        annotationLayout.shapeSuggestionsLayout = (ShapeSuggestionsLayout)annotationLayout.findViewById(R.id.shapeSuggestionsLayout);
        annotationLayout.shapeSuggestionsLayout.setOnShapeSelectedListener(new ShapeSuggestionsLayout.d(){

            @Override
            public void a(int n) {
                if (n == 1) {
                    AnnotationLayout.this.annotationView.b();
                }
            }
        });
        annotationLayout.iconBrushLayout = (RelativeLayout)annotationLayout.findViewById(R.id.icon_brush_layout);
        annotationLayout.iconBrush = (ImageView)annotationLayout.findViewById(R.id.icon_brush);
        annotationLayout.iconMagnify = (ImageView)annotationLayout.findViewById(R.id.icon_magnify);
        annotationLayout.iconBlur = (ImageView)annotationLayout.findViewById(R.id.icon_blur);
        annotationLayout.iconUndo = (ImageView)annotationLayout.findViewById(R.id.icon_undo);
        annotationLayout.iconBrush.setEnabled(false);
        annotationLayout.iconMagnify.setEnabled(false);
        annotationLayout.iconBlur.setEnabled(false);
        annotationLayout.iconUndo.setEnabled(false);
        annotationLayout.border = annotationLayout.findViewById(R.id.instabug_annotation_image_border);
        annotationLayout.annotationView = (AnnotationView)annotationLayout.findViewById(R.id.instabug_annotation_image);
        annotationLayout.colorPicker = (ColorPickerPopUpView)annotationLayout.findViewById(R.id.instabug_color_picker);
        annotationLayout.brushIndicator = annotationLayout.findViewById(R.id.brush_indicator);
        annotationLayout.annotationView.setDrawingMode(AnnotationView.c.DRAW_PATH);
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBrush, Instabug.getPrimaryColor());
        annotationLayout.annotationView.setDrawingColor(this.colorPicker.getSelectedColor());
        annotationLayout.annotationView.setOnActionDownListener(new AnnotationView.f(){

            @Override
            public void a() {
                if (AnnotationLayout.this.colorPicker.getVisibility() == 0) {
                    AnnotationLayout.this.colorPicker.setVisibility(8);
                }
                AnnotationLayout.this.shapeSuggestionsLayout.a();
            }
        });
        annotationLayout.annotationView.setOnPathRecognizedListener(new AnnotationView.h(){

            @Override
            public void a(Path path, Path path2) {
                AnnotationLayout.this.showShapeSuggestions(new Path[]{path, path2});
            }
        });
        annotationLayout.annotationView.setOnNewMagnifierAddingA\u0650\u0650\u0650bilityChangedListener(new AnnotationView.g(){

            @Override
            public void a(boolean bl) {
                AnnotationLayout.this.iconMagnify.setEnabled(bl);
            }
        });
        annotationLayout.colorPicker.setOnColorSelectionListener(new ColorPickerPopUpView.b(){

            @Override
            public void a(@ColorInt int n, int n2) {
                e e2 = this;
                e2.AnnotationLayout.this.annotationView.setDrawingColor(n);
                e2.AnnotationLayout.this.colorPicker.setVisibility(8);
                e2.AnnotationLayout.this.brushIndicator.setBackgroundColor(n);
            }
        });
        annotationLayout.colorPicker.setPopUpBackgroundColor(AttrResolver.resolveAttributeColor(this.getContext(), R.attr.ib_annotation_color_picker_bg_color));
        annotationLayout.iconBrushLayout.setOnClickListener((View.OnClickListener)this);
        annotationLayout.iconMagnify.setOnClickListener((View.OnClickListener)this);
        annotationLayout.iconBlur.setOnClickListener((View.OnClickListener)this);
        annotationLayout.iconUndo.setOnClickListener((View.OnClickListener)this);
        annotationLayout.setViewSelector(annotationLayout.iconMagnify);
        annotationLayout.setViewSelector(annotationLayout.iconUndo);
        annotationLayout.tintingColor = ContextCompat.getColor((Context)annotationLayout.getContext(), (int)R.color.ib_core_annotation_tinting_color);
    }

    /*
     * WARNING - void declaration
     */
    private void showShapeSuggestions(Path ... paths) {
        this.shapeSuggestionsLayout.removeAllViews();
        int n = paths.length;
        for (int i2 = 0; i2 < n; ++i2) {
            void var1_1;
            void var4_4 = var1_1[i2];
            this.shapeSuggestionsLayout.a((Path)var4_4);
        }
        this.shapeSuggestionsLayout.b();
    }

    private void setBorder() {
        ShapeDrawable shapeDrawable;
        AnnotationLayout annotationLayout = this;
        int n = ViewUtils.convertDpToPx(annotationLayout.getContext(), 4.0f);
        int n2 = ViewUtils.convertDpToPx(annotationLayout.getContext(), 2.0f);
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        new ShapeDrawable().setShape((Shape)new RectShape());
        shapeDrawable2.getPaint().setColor(Instabug.getPrimaryColor());
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setStrokeWidth((float)n);
        int n3 = n2;
        annotationLayout.border.setPadding(n3, n3, n3, n3);
        if (Build.VERSION.SDK_INT >= 16) {
            this.border.setBackground((Drawable)shapeDrawable2);
        } else {
            this.border.setBackgroundDrawable((Drawable)shapeDrawable2);
        }
    }

    private void setViewSelector(final ImageView viewSelector) {
        viewSelector.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    DrawableUtils.setDrawableTintColor(viewSelector, Instabug.getPrimaryColor());
                } else if (motionEvent.getAction() == 1) {
                    DrawableUtils.setDrawableTintColor(viewSelector, AnnotationLayout.this.tintingColor);
                }
                return false;
            }
        });
    }

    private void switchColorPickerVisibility() {
        Object this_ = this_.colorPicker;
        int n = this_.getVisibility() == 0 ? 8 : 0;
        this_.setVisibility(n);
    }

    private void hideColorPicker() {
        if (this.colorPicker.getVisibility() == 0) {
            this.colorPicker.setVisibility(8);
        }
    }

    private void resetColorSelection() {
        int n = this.annotationActionsContainer.getChildCount();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!(this.annotationActionsContainer.getChildAt(i2) instanceof IconView)) continue;
            ((TextView)this.annotationActionsContainer.getChildAt(i2)).setTextColor(this.tintingColor);
        }
        AnnotationLayout annotationLayout = this;
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBrush, this.tintingColor);
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBlur, this.tintingColor);
    }

    private void enableButtons() {
        AnnotationLayout annotationLayout = this;
        annotationLayout.iconBrush.setEnabled(true);
        annotationLayout.iconMagnify.setEnabled(true);
        annotationLayout.iconBlur.setEnabled(true);
        annotationLayout.iconUndo.setEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(View v2) {
        void var1_2;
        this.shapeSuggestionsLayout.a();
        int v2 = v2.getId();
        if (v2 == R.id.icon_brush_layout) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.switchColorPickerVisibility();
            annotationLayout.annotationView.setDrawingMode(AnnotationView.c.DRAW_PATH);
            annotationLayout.resetColorSelection();
            DrawableUtils.setDrawableTintColor(annotationLayout.iconBrush, Instabug.getPrimaryColor());
        } else if (var1_2 == R.id.icon_magnify) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.annotationView.a();
            annotationLayout.hideColorPicker();
        } else if (var1_2 == R.id.icon_blur) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.annotationView.setDrawingMode(AnnotationView.c.DRAW_BLUR);
            annotationLayout.resetColorSelection();
            DrawableUtils.setDrawableTintColor(annotationLayout.iconBlur, Instabug.getPrimaryColor());
            annotationLayout.hideColorPicker();
        } else if (var1_2 == R.id.icon_undo) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.annotationView.d();
            annotationLayout.hideColorPicker();
        }
    }

    public void setBaseImage(@NonNull Uri imageUri, final @Nullable Runnable runnable) {
        BitmapUtils.loadBitmap(imageUri.getPath(), this.annotationView, new BitmapWorkerTask.OnImageLoadedListener(){

            @Override
            public void onImageLoaded() {
                g g2 = runnable2;
                g2.AnnotationLayout.this.enableButtons();
                g2.AnnotationLayout.this.setBorder();
                Runnable runnable2 = g2.runnable;
                if (runnable2 != null) {
                    runnable2.run();
                }
            }
        });
    }

    public void setBitmap(Bitmap bitmap) {
        AnnotationLayout annotationLayout = this;
        annotationLayout.annotationView.setImageBitmap(bitmap);
        annotationLayout.enableButtons();
        annotationLayout.setBorder();
    }

    @Nullable
    public Bitmap getAnnotatedBitmap() {
        return this.annotationView.c();
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putParcelable(ANNOTATION_LAYOUT, super.onSaveInstanceState());
        bundle.putSerializable(DRAWING_MODE, (Serializable)this.annotationView.getDrawingMode());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle;
        this.annotationView.setDrawingColor(this.colorPicker.getSelectedColor());
        if (state instanceof Bundle) {
            bundle = bundle;
            AnnotationView.c c2 = (AnnotationView.c)bundle.getSerializable(DRAWING_MODE);
            this.resetColorSelection();
            if (c2 == AnnotationView.c.DRAW_BLUR) {
                DrawableUtils.setDrawableTintColor(this.iconBlur, Instabug.getPrimaryColor());
            } else {
                DrawableUtils.setDrawableTintColor(this.iconBrush, Instabug.getPrimaryColor());
            }
            bundle = bundle.getParcelable(ANNOTATION_LAYOUT);
        }
        super.onRestoreInstanceState((Parcelable)bundle);
    }
}

