/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.Process;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.InstabugThemeResolver;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StatusBarUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class BaseFragmentActivity<P extends BaseContract.Presenter>
extends AppCompatActivity
implements _InstabugActivity,
BaseContract.View<AppCompatActivity> {
    private static final String IB_PID = "INSTABUG_PROCESS_ID";
    @Nullable
    protected P presenter;

    public void onCreate(Bundle savedInstanceState) {
        BaseFragmentActivity baseFragmentActivity = this;
        BaseFragmentActivity baseFragmentActivity2 = this;
        InstabugSDKLogger.i(baseFragmentActivity2, "onCreate called");
        StatusBarUtils.setStatusBar((Activity)baseFragmentActivity2);
        LocaleUtils.setLocale((Activity)baseFragmentActivity2, Instabug.getLocale((Context)baseFragmentActivity2));
        super.onCreate(savedInstanceState);
        baseFragmentActivity.setTheme(InstabugThemeResolver.resolveTheme(SettingsManager.getInstance().getTheme()));
        baseFragmentActivity.setContentView(baseFragmentActivity.getLayout());
        baseFragmentActivity.initViews();
        baseFragmentActivity.getWindow().getDecorView().setId(R.id.instabug_decor_view);
    }

    public void onStart() {
        BaseFragmentActivity baseFragmentActivity = this;
        InstabugSDKLogger.i(baseFragmentActivity, "onStart called");
        super.onStart();
    }

    protected void onResume() {
        Intent intent;
        BaseFragmentActivity baseFragmentActivity = this_;
        super.onResume();
        InstabugSDKLogger.d(baseFragmentActivity, "onResume(),  SDK Invoking State Changed: true");
        BaseFragmentActivity this_ = intent;
        new Intent().setAction("SDK invoked");
        this_.putExtra("SDK invoking state", true);
        LocalBroadcastManager.getInstance((Context)baseFragmentActivity).sendBroadcast((Intent)this_);
    }

    protected void onPause() {
        Intent intent;
        BaseFragmentActivity baseFragmentActivity = this_;
        super.onPause();
        InstabugSDKLogger.d(baseFragmentActivity, "onPause(),  SDK Invoking State Changed: false");
        BaseFragmentActivity this_ = intent;
        new Intent().setAction("SDK invoked");
        this_.putExtra("SDK invoking state", false);
        LocalBroadcastManager.getInstance((Context)baseFragmentActivity).sendBroadcast((Intent)this_);
    }

    public void onStop() {
        BaseFragmentActivity baseFragmentActivity = this;
        InstabugSDKLogger.i(baseFragmentActivity, "onStop called");
        super.onStop();
    }

    protected void onDestroy() {
        BaseFragmentActivity baseFragmentActivity = this;
        InstabugSDKLogger.i(baseFragmentActivity, "onDestroy called");
        super.onDestroy();
    }

    @Override
    public AppCompatActivity getViewContext() {
        return this;
    }

    @Override
    public void finishActivity() {
        this.finish();
    }

    @LayoutRes
    protected abstract int getLayout();

    protected abstract void initViews();

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        super.onSaveInstanceState(outState, outPersistentState);
        outState.putInt(IB_PID, Process.myPid());
    }

    /*
     * WARNING - void declaration
     */
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        void var1_1;
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null && var1_1.getInt(IB_PID, -1) != Process.myPid()) {
            this.finishActivity();
        }
    }
}

