/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.d;
import com.instabug.library.logging.f;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InstabugUserEventLogger {
    private static final long DELAY = 1L;
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 1000;
    private List<UserEvent> userEvents = new ArrayList<UserEvent>();
    private ConcurrentHashMap<String, Integer> userEventsCount = new ConcurrentHashMap();

    private InstabugUserEventLogger() {
    }

    public static InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    /*
     * WARNING - void declaration
     */
    private void runInsertionHandler(String uuid, boolean anonymous) {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            void var2_2;
            void var1_1;
            MemoryGuard.from(context).withPredicate(new MemoryNotLowPredicate()).doAction(new Action((String)var1_1, (boolean)var2_2){
                final /* synthetic */ String a;
                final /* synthetic */ boolean b;
                {
                    this.a = string2;
                    this.b = bl;
                }

                @Override
                public void onAffirmed() {
                    block3: {
                        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                for (Map.Entry entry : InstabugUserEventLogger.this.userEventsCount.entrySet()) {
                                    b object = this;
                                    InstabugUserEventLogger.this.incrementEventLoggingCount((String)entry.getKey(), (Integer)entry.getValue(), object.a, object.b);
                                }
                                InstabugUserEventLogger.this.userEventsCount.clear();
                            }
                        };
                        try {
                            scheduledExecutorService.schedule(runnable, 1L, TimeUnit.SECONDS);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            if (outOfMemoryError.getMessage() == null) break block3;
                            InstabugSDKLogger.e(InstabugUserEventLogger.class, outOfMemoryError.getMessage());
                        }
                    }
                }

                @Override
                public void onDenied() throws Throwable {
                    InstabugSDKLogger.e(this, "Failed to update user events due to low memory");
                }
            });
        }
    }

    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy, String uuid, boolean anonymous) {
        String string2 = eventIdentifier;
        f.a(string2, f.b(string2, com.instabug.library.user.b.h()) + incrementBy, uuid, anonymous);
    }

    public synchronized void logUserEvent(final @NonNull String eventIdentifier, final UserEventParam ... userEventParams) throws IllegalStateException {
        PoolProvider.getUserEventLoggerExecuter().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class), new Api.Parameter().setName("userEventParams").setType(UserEventParam.class));
                if (d.c().a((Object)Feature.USER_EVENTS) == Feature.State.ENABLED) {
                    UserEvent userEvent = new UserEvent().setEventIdentifier(eventIdentifier).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
                    Object object = userEventParams;
                    int n = userEventParams.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        userEvent.addParam(object[i2]);
                    }
                    if (InstabugUserEventLogger.this.userEvents.size() >= 1000) {
                        InstabugUserEventLogger.this.userEvents.remove(0);
                    }
                    a a2 = this;
                    a2.InstabugUserEventLogger.this.userEvents.add(userEvent);
                    object = (Integer)a2.InstabugUserEventLogger.this.userEventsCount.get(eventIdentifier);
                    if (object != null) {
                        InstabugUserEventLogger.this.userEventsCount.put(eventIdentifier, (Integer)object + 1);
                    } else {
                        InstabugUserEventLogger.this.userEventsCount.put(eventIdentifier, 1);
                    }
                    UserEventsEventBus.getInstance().post(userEvent);
                }
                InstabugUserEventLogger.this.runInsertionHandler(com.instabug.library.user.b.h(), com.instabug.library.user.b.k() ^ true);
            }
        });
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userEventIdentifier").setType(String.class));
        return f.b(userEventIdentifier, com.instabug.library.user.b.h());
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    public void clearAll() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        f.a(com.instabug.library.user.b.h());
    }
}

