/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.d.a;
import com.instabug.library.invocation.d.d;
import com.instabug.library.invocation.d.f;
import com.instabug.library.invocation.d.g;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InvocationManager {
    public static final String TAG = "InvocationManager";
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private InstabugInvocationEvent[] currentInstabugInvocationEvents;
    private List<a> currentInvokers;
    @Nullable
    private a lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private boolean isInvocationAvailable;
    private com.instabug.library.invocation.b invocationRequestListenerImp;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.isInvocationAvailable = true;
        invocationManager.currentInvocationSettings = new InvocationSettings();
        invocationManager.currentInstabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
        invocationManager.currentInvokers = new ArrayList<a>();
        invocationManager.subscribeToCarenActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new com.instabug.library.invocation.b();
    }

    public static void init() {
        InstabugSDKLogger.d(TAG, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (InstabugCore.getTargetActivity() != null) {
            INSTANCE.listen();
        }
    }

    public static InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void listen() {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && ((InvocationManager)((Object)iterator)).isInvocationAvailable && ((InvocationManager)((Object)iterator)).isPromptOptionsAvailable() && ((InvocationManager)((Object)iterator)).currentInvokers != null && InstabugCore.getTargetActivity() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            Iterator<a> iterator = ((InvocationManager)((Object)iterator)).currentInvokers.iterator();
            while (iterator.hasNext()) {
                ((a)iterator.next()).a();
            }
        }
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n = b.b[activityLifeCycleEvent.ordinal()];
                if (n != 1) {
                    if (n == 2) {
                        InstabugSDKLogger.d(InvocationManager.TAG, "current activity paused");
                        InvocationManager.this.sleep();
                    }
                } else {
                    InstabugSDKLogger.d(InvocationManager.TAG, "current activity resumed");
                    InvocationManager.this.listen();
                }
            }
        });
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private com.instabug.library.invocation.d.b getFloatingButtonInvoker() {
        InvocationManager invocationManager = this_;
        Object this_ = null;
        List<a> list = invocationManager.currentInvokers;
        if (list != null) {
            for (a a2 : list) {
                if (!(a2 instanceof com.instabug.library.invocation.d.b)) continue;
                this_ = (com.instabug.library.invocation.d.b)a2;
                break;
            }
        }
        return this_;
    }

    @VisibleForTesting
    public static void tearDown() {
        INSTANCE = null;
    }

    public void release() {
        Disposable disposable = this.currentActivityLifeCycleDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        this.invocationRequestListenerImp = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        void var1_1;
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates(instabugInvocationEvent);
        List<a> list = invocationManager.currentInvokers;
        if (list != null) {
            list = list.iterator();
            while (list.hasNext()) {
                ((a)list.next()).b();
            }
            this.currentInvokers.clear();
        }
        int n = ((void)var1_1).length;
        block7: for (int i2 = 0; i2 < n; ++i2) {
            f f2 = var1_1[i2];
            InstabugSDKLogger.d(TAG, "set instabug invocation event: " + f2);
            if (f2 == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new ArrayList<a>();
            }
            switch (b.a[((Enum)((Object)f2)).ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    this.currentInvokers.add(new d(this.invocationRequestListenerImp));
                    continue block7;
                }
                case 3: {
                    this.currentInvokers.add(new g(Instabug.getApplicationContext(), this.invocationRequestListenerImp));
                    continue block7;
                }
                case 2: {
                    this.currentInvokers.add(new com.instabug.library.invocation.d.b(this.invocationRequestListenerImp));
                    continue block7;
                }
                case 1: {
                    f f3;
                    f2 = f3;
                    f2(Instabug.getApplicationContext(), this.invocationRequestListenerImp);
                    f3.a(this.currentInvocationSettings.getShakeThreshold());
                    this.currentInvokers.add(f2);
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    InstabugInvocationEvent[] removeDuplicates(InstabugInvocationEvent[] events) {
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n = events.length;
        for (int i2 = 0; i2 < n; ++i2) {
            void var1_1;
            void var5_5 = var1_1[i2];
            if (hashSet2.contains(var5_5)) continue;
            this_.add(var5_5);
            hashSet2.add(var5_5);
        }
        Object object = this_;
        return ((ArrayList)object).toArray(new InstabugInvocationEvent[((ArrayList)object).size()]);
    }

    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        return Arrays.copyOf(this.currentInstabugInvocationEvents, this.currentInstabugInvocationEvents.length);
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    List<a> getCurrentInvokers() {
        return this.currentInvokers;
    }

    @Nullable
    public a getLastUsedInvoker() {
        return this.lastUsedInvoker;
    }

    public void setLastUsedInvoker(@Nullable a lastUsedInvoker) {
        this.lastUsedInvoker = lastUsedInvoker;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (a a2 : ((InvocationManager)this).currentInvokers) {
                void var1_1;
                if (!(a2 instanceof g)) continue;
                ((g)a2).a((MotionEvent)var1_1);
                break;
            }
        }
    }

    public void sleep() {
        Object this_ = ((InvocationManager)this_).currentInvokers;
        if (this_ != null) {
            this_ = this_.iterator();
            while (this_.hasNext()) {
                ((a)this_.next()).b();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable = false;
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable = true;
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.a.c();
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && (iterator = ((InvocationManager)((Object)iterator)).currentInvokers) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                a a2 = (a)iterator.next();
                if (InstabugCore.getTargetActivity() == null || !(a2 instanceof com.instabug.library.invocation.d.b)) continue;
                a a3 = a2;
                a3.b();
                a3.a();
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        com.instabug.library.invocation.d.b b2 = invocationManager.getFloatingButtonInvoker();
        if (b2 != null) {
            if (bl) {
                b2.b();
            } else {
                b2.d();
            }
        }
    }

    public void show() {
        this.invocationRequestListenerImp.a();
        this.lastUsedInvoker = null;
    }

    public void invoke(int invocationMode) {
        this.invocationRequestListenerImp.b(invocationMode);
    }

    public void forceInvoke(int invocationMode) {
        this.invocationRequestListenerImp.a(invocationMode);
    }
}

