/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.settings;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.d;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.model.Report;
import com.instabug.library.settings.a;
import com.instabug.library.settings.b;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public class SettingsManager {
    public static final boolean VERBOSE = false;
    private static final String TAG = "Core-SettingManager";
    public static final String INSTABUG_SHARED_PREF_NAME = "instabug";
    public static final int MAX_ASR_DURATION_IN_SECONDS = 180;
    public static final int MIN_ASR_DURATION_IN_SECONDS = 30;
    private static final String ASR_DURATION_ERROR_MSG_BELOW_MIN = "Auto screen recording duration should be in a range from 30 to 180 seconds. Falling back to %d seconds";
    private static SettingsManager settingsManager;
    private boolean DEBUG = false;

    public static synchronized SettingsManager getInstance() {
        if (settingsManager == null) {
            settingsManager = new SettingsManager();
        }
        return settingsManager;
    }

    private String getASRError(int duration) {
        Object[] objectArray;
        if (duration < 30) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = 30;
            return String.format(Locale.ENGLISH, ASR_DURATION_ERROR_MSG_BELOW_MIN, objectArray);
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = 180;
        return String.format(Locale.ENGLISH, ASR_DURATION_ERROR_MSG_BELOW_MIN, objectArray);
    }

    private int convertSecondToMilliseconds(int seconds) {
        return (int)TimeUnit.MILLISECONDS.convert(seconds, TimeUnit.SECONDS);
    }

    public static void setInitialScreenShotAllowed(boolean initialScreenShotAllowed) {
        a.C().c(initialScreenShotAllowed);
    }

    public static boolean isInitialScreenShotAllowed() {
        return a.C().s();
    }

    public boolean isDebugEnabled() {
        return this.DEBUG;
    }

    public void setDebugEnabled(boolean isDebugEnabled) {
        this.DEBUG = isDebugEnabled;
    }

    public String getAppToken() {
        return a.C().g();
    }

    public void setAppToken(String token) {
        a.C().a(token);
    }

    public OnInvokeCallback getOnInvokeCallback() {
        return a.C().h();
    }

    public void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) {
        a.C().a(onInvokeCallback);
    }

    public OnSdkInvokedCallback getOnSdkInvokedCallback() {
        return a.C().k();
    }

    public Report.OnReportCreatedListener getOnReportCreatedListener() {
        return a.C().i();
    }

    public void setOnReportCreatedListener(Report.OnReportCreatedListener listener) {
        a.C().a(listener);
    }

    public void setOnSdkInvokedCallback(OnSdkInvokedCallback onSdkInvokedCallback) {
        a.C().a(onSdkInvokedCallback);
    }

    public String getUserData() {
        if (d.c().a((Object)Feature.USER_DATA) == Feature.State.ENABLED) {
            return b.D().o();
        }
        return "";
    }

    public void setUserData(String userData) {
        b.D().h(userData);
    }

    public Locale getInstabugLocale(Context context) {
        return a.C().a(context);
    }

    public void setInstabugLocale(Locale instabugLocale) {
        a.C().a(instabugLocale);
    }

    public void addExtraAttachmentFile(Uri attachmentUri, String fileNameWithExtension) {
        a.C().a(attachmentUri, fileNameWithExtension);
    }

    public void addExtraAttachmentFile(byte[] data, String fileNameWithExtension) {
        a.C().a(AttachmentsUtility.getUriFromBytes(Instabug.getApplicationContext(), data, fileNameWithExtension), fileNameWithExtension);
    }

    public void clearExtraAttachmentFiles() {
        a.C().c();
    }

    public LinkedHashMap<Uri, String> getExtraAttachmentFiles() {
        return a.C().f();
    }

    @NonNull
    public String getIdentifiedUserEmail() {
        return b.D().e();
    }

    public void setIdentifiedUserEmail(String identifiedUserEmail) {
        b.D().d(identifiedUserEmail);
    }

    public boolean isDeviceRegistered() {
        return b.D().t();
    }

    public void setIsDeviceRegistered(boolean registered) {
        b.D().b(registered);
    }

    public boolean isFirstRun() {
        return b.D().v();
    }

    public void setIsFirstRun(boolean isFirstRun) {
        b.D().d(isFirstRun);
    }

    public Date getFirstRunAt() {
        return new Date(b.D().d());
    }

    public void setFirstRunAt(long time) {
        b.D().a(time);
    }

    @Deprecated
    public long getLastContactedAt() {
        return b.D().g();
    }

    @Deprecated
    public void setLastContactedAt(long lastContactedAt) {
        b.D().b(lastContactedAt);
    }

    public boolean isAppOnForeground() {
        return b.D().s();
    }

    public void setIsAppOnForeground(boolean isAppOnForeground) {
        b.D().a(isAppOnForeground);
    }

    public int getLastMigrationVersion() {
        return b.D().h();
    }

    public void setLastMigrationVersion(int lastMigrationVersion) {
        b.D().a(lastMigrationVersion);
    }

    public boolean isFirstDismiss() {
        return b.D().u();
    }

    public void setIsFirstDismiss(boolean firstDismiss) {
        b.D().c(firstDismiss);
    }

    public int getPrimaryColor() {
        return a.C().l();
    }

    public void setPrimaryColor(@ColorInt int primaryColorValue) {
        a.C().b(primaryColorValue);
        InvocationManager.getInstance().notifyPrimaryColorChanged();
    }

    public InstabugColorTheme getTheme() {
        return b.D().n();
    }

    public void setTheme(InstabugColorTheme instabugTheme) {
        b.D().a(instabugTheme);
    }

    public String getIdentifiedUsername() {
        return b.D().f();
    }

    public void setIdentifiedUsername(@Nullable String username) {
        b.D().e(username);
    }

    public void setEnteredUsername(String enteredUsername) {
        b.D().c(enteredUsername);
    }

    public String getEnteredUsername() {
        return b.D().b();
    }

    public String getUuid() {
        return b.D().p();
    }

    public void setUuid(String uuid) {
        b.D().i(uuid);
    }

    public String getMD5Uuid() {
        return b.D().l();
    }

    public void setMD5Uuid(String uuid) {
        b.D().g(uuid);
    }

    public ArrayList<String> getTags() {
        return a.C().q();
    }

    public void addTags(String ... tags) {
        a.C().a(tags);
    }

    public void resetTags() {
        a.C().B();
    }

    public String getTagsAsString() {
        StringBuilder stringBuilder;
        StringBuilder this_ = stringBuilder;
        stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = a.C().q();
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            for (int i2 = 0; i2 < n; ++i2) {
                this_.append(arrayList.get(i2));
                if (i2 == n - 1) continue;
                this_.append(", ");
            }
        }
        return this_.toString();
    }

    public long getSessionStartedAt() {
        return a.C().o();
    }

    public void setSessionStartedAt(long sessionStartedAt) {
        a.C().a(sessionStartedAt);
    }

    public InstabugCustomTextPlaceHolder getCustomPlaceHolders() {
        return a.C().e();
    }

    public void setCustomPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        a.C().a(instabugCustomTextPlaceHolder);
    }

    public boolean isUserLoggedOut() {
        return b.D().y();
    }

    public void setUserLoggedOut(boolean isUserLoggedOut) {
        b.D().h(isUserLoggedOut);
    }

    public boolean shouldMakeUUIDMigrationRequest() {
        return b.D().B();
    }

    public void setShouldMakeUUIDMigrationRequest(boolean shouldMigrate) {
        b.D().g(shouldMigrate);
    }

    public void setCurrentSDKVersion(String sdkVersion) {
        b.D().a(sdkVersion);
    }

    public String getLastSDKVersion() {
        return b.D().i();
    }

    public boolean isSDKVersionSet() {
        return b.D().w();
    }

    public int getStatusBarColor() {
        return a.C().p();
    }

    public void setStatusBarColor(int statusBarColor) {
        a.C().d(statusBarColor);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        a.C().c(requestedOrientation);
    }

    public int getRequestedOrientation() {
        return a.C().n();
    }

    public void resetRequestedOrientation() {
        a.C().A();
    }

    public int getSessionsCount() {
        return b.D().m();
    }

    public void updateUserSessionCount(int sessionCount) {
        b.D().b(sessionCount);
    }

    public void resetSessionCount() {
        b.D().z();
    }

    public void incrementSessionsCount() {
        b.D().r();
    }

    public boolean isPromptOptionsScreenShown() {
        return a.C().v();
    }

    public void setPromptOptionsScreenShown(boolean promptOptionsShown) {
        a.C().f(promptOptionsShown);
    }

    public boolean isRequestPermissionScreenShown() {
        return a.C().x();
    }

    public void setRequestPermissionScreenShown(boolean isRequestPermissionScreenShown) {
        a.C().h(isRequestPermissionScreenShown);
    }

    public OnSdkDismissedCallback getOnSdkDismissedCallback() {
        return a.C().j();
    }

    public void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) {
        a.C().a(onSdkDismissedCallback);
    }

    public void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        a.C().b(autoScreenRecordingEnabled);
    }

    public boolean autoScreenRecordingEnabled() {
        return a.C().a();
    }

    public void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        int n;
        a this_ = a.C();
        if (autoScreenRecordingMaxDuration > 30000) {
            n = 30000;
        }
        this_.a(n);
    }

    public int autoScreenRecordingMaxDuration() {
        return a.C().b();
    }

    public boolean isScreenCurrentlyRecorded() {
        return a.C().y();
    }

    public void setScreenCurrentlyRecorded(boolean screenCurrentlyRecorded) {
        a.C().i(screenCurrentlyRecorded);
    }

    public boolean isAutoScreenRecordingDenied() {
        return a.C().r();
    }

    public void setAutoScreenRecordingDenied(boolean autoScreenRecordingDenied) {
        a.C().a(autoScreenRecordingDenied);
    }

    public void setReproStepsScreenshotEnabled(boolean enable) {
        a.C().g(enable);
    }

    public boolean isReproStepsScreenshotEnabled() {
        return a.C().w();
    }

    public void setEnteredEmail(String enteredEmail) {
        b.D().b(enteredEmail);
    }

    public String getEnteredEmail() {
        return b.D().a();
    }

    public void setScreenshotByMediaProjectionEnabled(boolean enabled) {
        a.C().j(enabled);
    }

    public boolean isScreenshotByMediaProjectionEnabled() {
        return a.C().z();
    }

    public WelcomeMessage.State getWelcomeMessageState() {
        return WelcomeMessage.State.valueOf(b.D().q());
    }

    public void setWelcomeMessageState(WelcomeMessage.State welcomeMessageState) {
        b.D().a(welcomeMessageState);
    }

    public void setIsSessionEnabled(boolean enabled) {
        b.D().e(enabled);
    }

    public boolean isSessionEnabled() {
        return b.D().x();
    }

    public void setOnboardingShowing(boolean onboardingShowing) {
        a.C().d(onboardingShowing);
    }

    public boolean isOnboardingShowing() {
        return a.C().t();
    }

    public void setShouldAutoShowOnboarding(boolean shouldShowOnboarding) {
        b.D().f(shouldShowOnboarding);
    }

    public boolean shouldAutoShowOnboarding() {
        return b.D().A();
    }

    public boolean isProcessingForeground() {
        return a.C().u();
    }

    public void setProcessingForeground(boolean isProcessingForeground) {
        a.C().e(isProcessingForeground);
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoScreenRecordingDuration(int autoScreenRecordingMaxDuration) {
        void var1_1;
        if (autoScreenRecordingMaxDuration > 180) {
            Log.w((String)Instabug.class.getName(), (String)this.getASRError((int)var1_1));
            a.C().a(this.convertSecondToMilliseconds(180));
            return;
        }
        if (var1_1 < 30) {
            Log.w((String)Instabug.class.getName(), (String)this.getASRError((int)var1_1));
            a.C().a(this.convertSecondToMilliseconds(30));
            return;
        }
        a.C().a((int)(var1_1 * 1000));
    }

    public void setAutoScreenRecordingAudioCapturingState(Feature.State asrAudioCapturingEnabled) {
        a.C().a(asrAudioCapturingEnabled);
    }

    public Feature.State getAutoScreenRecordingAudioCapturingState() {
        return a.C().d();
    }

    public void setLastSeenTimestamp(long currentTimeMillis) {
        b.D().c(currentTimeMillis);
    }

    public long getLastSeenTimestamp() {
        return b.D().j();
    }

    public void setViewsAsPrivate(View ... views) {
        a.C().a(views);
    }

    public Collection<WeakReference<View>> getPrivateViews() {
        return a.C().m();
    }

    public void release() {
        a.D();
    }

    public com.instabug.library.model.b getFeaturesCache() throws JSONException {
        return b.D().c();
    }

    public void setFeaturesCache(com.instabug.library.model.b cache) throws JSONException {
        b.D().a(cache);
    }

    public void setLoggingFeatureSettings(String loggingSettings) {
        b.D().f(loggingSettings);
    }

    public String getLoggingFeatureSettings() {
        return b.D().k();
    }
}

