/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.video.RequestPermissionActivity;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.internal.video.ScreenRecordingFileHolder;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.g;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;

public class InternalAutoScreenRecorderHelper
implements ScreenRecordingContract {
    private static InternalAutoScreenRecorderHelper INSTANCE;
    private static Intent staticIntentData;
    private static int staticResultCode;
    private ScreenRecordingFileHolder fileHolder;
    private Disposable sessionDisposable;
    private Disposable activityLifeCycleDisposable;
    private boolean isCrashOccurred;

    public InternalAutoScreenRecorderHelper() {
        InternalAutoScreenRecorderHelper internalAutoScreenRecorderHelper = this;
        internalAutoScreenRecorderHelper.isCrashOccurred = false;
        internalAutoScreenRecorderHelper.fileHolder = new ScreenRecordingFileHolder();
        internalAutoScreenRecorderHelper.subscribeToSessionEvents();
        internalAutoScreenRecorderHelper.subscribeToActivityLifeCycleEvents();
    }

    private void subscribeToSessionEvents() {
        Disposable disposable = this.sessionDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer<g.a>(){

                public void a(g.a a2) {
                    if (a2 == g.a.FINISH && !InternalAutoScreenRecorderHelper.this.isCrashOccurred() && InternalAutoScreenRecorderHelper.this.isEnabled()) {
                        AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_DELETE);
                        SettingsManager.getInstance().setAutoScreenRecordingDenied(false);
                        InternalAutoScreenRecorderHelper.this.unsubscribeFromSessionEvents();
                    }
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    private void subscribeToActivityLifeCycleEvents() {
        Disposable disposable = this.activityLifeCycleDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.activityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

                public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                    if (activityLifeCycleEvent == ActivityLifeCycleEvent.RESUMED && InternalAutoScreenRecorderHelper.this.isEnabled() && !SettingsManager.getInstance().isProcessingForeground()) {
                        InternalAutoScreenRecorderHelper.this.subscribeToSessionEvents();
                        new Handler().postDelayed(new Runnable(this){

                            @Override
                            public void run() {
                                InternalAutoScreenRecorderHelper.getInstance().start();
                            }
                        }, 700L);
                    }
                }
            });
        }
    }

    public static InternalAutoScreenRecorderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalAutoScreenRecorderHelper();
        }
        return INSTANCE;
    }

    static int getStaticResultCode() {
        return staticResultCode;
    }

    static Intent getStaticIntentData() {
        return staticIntentData;
    }

    static void setStaticIntentData(Intent staticIntentData) {
        InternalAutoScreenRecorderHelper.staticIntentData = staticIntentData;
    }

    static void setStaticResultCode(int staticResultCode) {
        InternalAutoScreenRecorderHelper.staticResultCode = staticResultCode;
    }

    public boolean isCrashOccurred() {
        return this.isCrashOccurred;
    }

    public void setCrashOccurred(boolean isCrashOccurred) {
        this.isCrashOccurred = isCrashOccurred;
    }

    public void start() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (!SettingsManager.getInstance().isScreenCurrentlyRecorded() && !SettingsManager.getInstance().isAutoScreenRecordingDenied() && internalAutoScreenRecorderHelper.isEnabled()) {
            InternalAutoScreenRecorderHelper internalAutoScreenRecorderHelper = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
            if (internalAutoScreenRecorderHelper != null && !(internalAutoScreenRecorderHelper instanceof _InstabugActivity) && SettingsManager.getInstance().isAppOnForeground() && Instabug.getState() == InstabugState.ENABLED && !InstabugCore.isForegroundBusy()) {
                InternalAutoScreenRecorderHelper internalAutoScreenRecorderHelper2 = internalAutoScreenRecorderHelper;
                internalAutoScreenRecorderHelper2.startActivity(new Intent((Context)internalAutoScreenRecorderHelper, RequestPermissionActivity.class));
                internalAutoScreenRecorderHelper2.overridePendingTransition(0, 0);
            }
            return;
        }
    }

    @Override
    public Uri getAutoScreenRecordingFileUri() {
        return this.fileHolder.getAutoScreenRecordingFileUri();
    }

    @Override
    public void delete() {
        this.fileHolder.delete();
    }

    @Override
    public void clear() {
        this.fileHolder.clear();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.getInstance().autoScreenRecordingEnabled();
    }

    public void setAutoScreenRecordingFile(File autoScreenRecordingFile) {
        this.fileHolder.setAutoScreenRecordingFile(autoScreenRecordingFile);
    }
}

