/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.core.os.ConfigurationCompat;
import com.instabug.library.g;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.device.a;
import com.instabug.library.tracking.e;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DeviceStateProvider {
    private static final String NONE_SSID = "<unknown ssid>";

    public static String getDevice() {
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        try {
            return a.d();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            return false;
        }
    }

    public static String getOS() {
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get Carrier", exception);
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        return InstabugDeviceProperties.getAppVersion(context);
    }

    public static int getBatteryLevel(Context context) {
        block6: {
            IntentFilter intentFilter;
            Context context2 = context;
            Context context3 = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context3 = context2.registerReceiver(null, (IntentFilter)context3);
            if (context3 == null) break block6;
            Context context4 = context3;
            Context context5 = context4;
            int n = context4.getIntExtra("level", -1);
            return (int)((float)n / (float)context5.getIntExtra("scale", -1) * 100.0f);
        }
        try {
            InstabugSDKLogger.w("DeviceStateProvider", "Could't obtain battery level");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery level", exception);
        }
        return -1;
    }

    public static String getBatteryState(Context context) {
        block9: {
            CharSequence charSequence;
            block12: {
                block11: {
                    int n;
                    Context context2;
                    block10: {
                        IntentFilter intentFilter;
                        Context context3 = context;
                        context2 = intentFilter;
                        intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                        context2 = context3.registerReceiver(null, (IntentFilter)context2);
                        if (context2 == null) break block9;
                        n = context2.getIntExtra("status", -1);
                        if (n != 2 && n != 5) {
                            n = 0;
                            break block10;
                        }
                        n = 1;
                    }
                    int n2 = context2.getIntExtra("plugged", -1);
                    boolean bl = n2 == 2;
                    n2 = n2 == 1 ? 1 : 0;
                    if (n == 0) break block11;
                    charSequence = new StringBuilder().append("Charging");
                    String string2 = n2 != 0 ? " through AC Charger" : (bl ? " through USB cable" : "");
                    charSequence = ((StringBuilder)charSequence).append(string2).toString();
                    break block12;
                }
                charSequence = "Unplugged";
            }
            return charSequence;
        }
        try {
            InstabugSDKLogger.w("DeviceStateProvider", "Could't obtain battery state");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery state", exception);
        }
        return "Unknown";
    }

    public static boolean getWifiState(Context context) {
        try {
            return ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1).isConnected();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get wifi state", exception);
            return false;
        }
    }

    public static String getWifiSSID(Context context) {
        if (DeviceStateProvider.getWifiState(context)) {
            Object object;
            block5: {
                try {
                    object = ((WifiManager)object.getSystemService("wifi")).getConnectionInfo();
                }
                catch (SecurityException securityException) {
                    InstabugSDKLogger.e("DeviceStateProvider", "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                    return "Connected";
                }
                if (!object.getSSID().equalsIgnoreCase(NONE_SSID)) break block5;
                object = "";
            }
            object = object.getSSID();
            return object;
        }
        return "Not Connected";
    }

    public static long getFreeMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        context = memoryInfo;
        activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
        return context.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = context;
        context = memoryInfo;
        ((ActivityManager)context2.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return (DeviceStateProvider.calculateTotalMemory(context2) - context.availMem) / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        long l = DeviceStateProvider.calculateTotalMemory(context);
        if (l == 0L) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total memory");
            return -1L;
        }
        return l / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            Context context2;
            return DeviceStateProvider.calculateTotalMemoryApi16(context2);
        }
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        context = memoryInfo;
        activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
        return context.totalMem;
    }

    /*
     * Loose catch block
     */
    private static long calculateTotalMemoryPreApi16() {
        RandomAccessFile randomAccessFile;
        Object object;
        block19: {
            block20: {
                IOException iOException3;
                block18: {
                    RandomAccessFile randomAccessFile2;
                    object = null;
                    randomAccessFile = randomAccessFile2;
                    randomAccessFile2 = new RandomAccessFile("/proc/meminfo", "r");
                    String string2 = randomAccessFile2.readLine().split(":")[1].trim();
                    int n = 0;
                    int n2 = string2.length();
                    object = string2.substring(n, n2 - 3).trim();
                    randomAccessFile2.close();
                    long l = Long.parseLong((String)object) * 1024L;
                    try {
                        randomAccessFile2.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    return l;
                    catch (IOException iOException3) {
                        break block18;
                    }
                    catch (Throwable throwable) {
                        randomAccessFile = object;
                        object = throwable;
                        break block19;
                    }
                    catch (IOException iOException3) {
                        randomAccessFile = object;
                    }
                }
                iOException3.printStackTrace();
                if (randomAccessFile == null) break block20;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException4) {
                    iOException4.printStackTrace();
                }
            }
            return 0L;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        throw object;
    }

    public static long getFreeStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            return Environment.getExternalStorageDirectory().getUsableSpace() / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate free storage");
        return -1L;
    }

    public static long getUsedStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            return (Environment.getExternalStorageDirectory().getTotalSpace() - Environment.getExternalStorageDirectory().getFreeSpace()) / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate used storage");
        return -1L;
    }

    public static long getTotalStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            return (int)(Environment.getExternalStorageDirectory().getTotalSpace() / 0x100000L);
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total storage");
        return -1L;
    }

    private static boolean externalMemoryAvailable() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(DeviceStateProvider.class, exception.getMessage(), exception);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getScreenDensity(Context context2) {
        void var0_1;
        int context2 = DeviceStateProvider.getDisplayMetrics((Context)context2).densityDpi;
        if (context2 < 160) {
            return "ldpi";
        }
        if (var0_1 < 240) {
            return "mdpi";
        }
        if (var0_1 < 320) {
            return "hdpi";
        }
        if (var0_1 < 480) {
            return "xhdpi";
        }
        if (var0_1 < 640) {
            return "xxhdpi";
        }
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        context = DeviceStateProvider.getDisplayMetrics(context);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = context.widthPixels;
        objectArray[1] = context.heightPixels;
        return String.format("%sx%s", objectArray2);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics;
        context = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics2 = displayMetrics;
        context.getMetrics(new DisplayMetrics());
        if (Build.VERSION.SDK_INT >= 17) {
            Context context2;
            context2.getRealMetrics(displayMetrics2);
        }
        return displayMetrics2;
    }

    public static String getScreenOrientation(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return "landscape";
        }
        return "portrait";
    }

    public static String getCurrentView() {
        return e.c().a();
    }

    public static String getSdkVersion() {
        return "9.0.5";
    }

    public static String getLocale(Context context) {
        Context context2;
        if (ConfigurationCompat.getLocales((Configuration)context.getResources().getConfiguration()).size() > 0) {
            return ConfigurationCompat.getLocales((Configuration)context2.getResources().getConfiguration()).get(0).getLanguage();
        }
        return context2.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        return g.i().c();
    }
}

