/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.c;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.model.j;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.d;
import com.instabug.library.tracking.e;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.g;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    public static final String TAG = "InstabugInternalTrackingDelegate";
    private static InstabugInternalTrackingDelegate INSTANCE;
    @Nullable
    private WeakReference<Activity> currentActivity;

    public static void init(Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(Application application) {
        if (application != null) {
            void var1_1;
            this.registerActivityLifecycleListener((Application)var1_1);
        }
    }

    private void registerActivityLifecycleListener(Application application) {
        InstabugSDKLogger.d(TAG, "Registering activity lifecycle listener");
        a a2 = new a();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a2);
        application.registerComponentCallbacks((ComponentCallbacks)a2);
    }

    private boolean isUserTrackingStepsEnable() {
        return c.b().a(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED;
    }

    private boolean isReproStepsEnable() {
        return c.b().a(Feature.REPRO_STEPS) == Feature.State.ENABLED;
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " created");
            e.c().a(var1_1.getClass().getName(), j.a.APPLICATION_CREATED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityCreatedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            void var1_1;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " created");
                e.c().a(var1_1.getClass().getName(), j.a.ACTIVITY_CREATED);
            }
            if (this.isReproStepsEnable()) {
                g.c().a(j.a.ACTIVITY_CREATED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityStartedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            void var1_1;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " started");
                e.c().a(var1_1.getClass().getName(), j.a.ACTIVITY_STARTED);
            }
            if (this.isReproStepsEnable()) {
                g.c().a(j.a.ACTIVITY_STARTED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            void var1_1;
            this.currentActivity = new WeakReference<void>(var1_1);
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " resumed");
                e.c().a(var1_1.getClass().getName(), j.a.ACTIVITY_RESUMED);
            }
            if (this.isReproStepsEnable()) {
                g.c().a(j.a.ACTIVITY_RESUMED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Activity activity2 = null;
        WeakReference<Activity> weakReference = this.currentActivity;
        if (weakReference != null) {
            activity2 = (Activity)weakReference.get();
        }
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (activity2 == null) {
                InstabugSDKLogger.w(TAG, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(activity2)) {
                InstabugSDKLogger.w(TAG, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " paused");
                e.c().a(var1_1.getClass().getName(), j.a.ACTIVITY_PAUSED);
            }
            if (this.isReproStepsEnable()) {
                g.c().a(j.a.ACTIVITY_PAUSED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityStoppedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            void var1_1;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " stopped");
                e.c().a(var1_1.getClass().getName(), j.a.ACTIVITY_STOPPED);
            }
            if (this.isReproStepsEnable()) {
                g.c().a(j.a.ACTIVITY_STOPPED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            WeakReference<Activity> weakReference;
            void var1_1;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " destroyed");
                e.c().a(var1_1.getClass().getName(), j.a.ACTIVITY_DESTROYED);
            }
            if (this.isReproStepsEnable()) {
                g.c().a(j.a.ACTIVITY_DESTROYED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
            }
            if (var1_1 != null && (weakReference = this.currentActivity) != null && weakReference.get() != null && var1_1 == this.currentActivity.get()) {
                this.currentActivity.clear();
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentAttached(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_ATTACHED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_ATTACHED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_VIEW_CREATED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_VIEW_CREATED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStarted(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_STARTED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_STARTED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_RESUMED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_RESUMED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentPaused(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_PAUSED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_PAUSED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStopped(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_STOPPED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_STOPPED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), j.a.FRAGMENT_DETACHED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_DETACHED, var1_1.getClass().getSimpleName(), var1_1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_2;
        Activity activity = this.currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                void var1_1;
                e.c().a(var2_2.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + (boolean)var1_1, j.a.FRAGMENT_VISIBILITY_CHANGED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.c().a(j.a.FRAGMENT_VISIBILITY_CHANGED, var2_2.getClass().getSimpleName(), var2_2.getClass().getName(), null);
        }
    }

    void trackTouchEvent(MotionEvent event, Activity activity) {
        d.a().a(activity, event);
    }

    @Nullable
    public Activity getCurrentActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = null;
        WeakReference<Activity> weakReference = instabugInternalTrackingDelegate.currentActivity;
        if (weakReference != null) {
            activity = (Activity)weakReference.get();
        }
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
        } else if (activity != null) {
            this_ = activity;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        com.instabug.library.core.eventbus.a this_ = com.instabug.library.core.eventbus.a.getInstance();
        this_.a((Configuration)var1_1);
        com.instabug.library.core.eventbus.a.getInstance().post(this_);
    }
}

