/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.content.Context;
import android.net.ConnectivityManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.a;
import com.instabug.library.network.c;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;

public class NetworkManager
implements a {
    public static final String TAG = "NetworkManager";
    public static final String APP_TOKEN = "application_token";
    public static final String UUID = "uuid";
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final int DEFAULT_CONNECTION_TIME_OUT = 15000;
    @Nullable
    private OnDoRequestListener onDoRequestListener;

    public static boolean isOnline(Context context) {
        block7: {
            if (context != null) {
                Context context2;
                context2 = (ConnectivityManager)context2.getSystemService("connectivity");
                if (context2 == null) break block7;
                context2 = context2.getActiveNetworkInfo();
                if (context2 == null) break block7;
                try {
                    if (context2.isConnectedOrConnecting()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, "Something went wrong while checking network state", exception);
                }
                catch (SecurityException securityException) {
                    InstabugSDKLogger.w(TAG, "Could not read network state. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>\n" + securityException.getMessage());
                }
            }
        }
        return false;
    }

    private Request buildRequest(@NonNull Context context, Request request) throws JSONException {
        Request request2 = request;
        request2.addParameter(APP_TOKEN, Instabug.getAppToken());
        request2.addParameter(UUID, com.instabug.library.user.b.g());
        return request2;
    }

    private HttpURLConnection setURLConnectionDefaultTimeOut(HttpURLConnection httpURLConnection) {
        return this.setURLConnectionTimeOut(httpURLConnection, 10000, 15000);
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection connectWithNormalType(Request request) throws IOException {
        void var1_1;
        InstabugSDKLogger.d(TAG, "Connect to: " + request.getRequestUrl() + " with normal type");
        HttpURLConnection httpURLConnection = this.buildConnection(request);
        this.setURLConnectionDefaultTimeOut(httpURLConnection);
        httpURLConnection.setRequestMethod(request.getRequestMethod().toString());
        if (request.getRequestMethod() == Request.RequestMethod.Post || var1_1.getRequestMethod() == Request.RequestMethod.put) {
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            httpURLConnection2.setDoOutput(true);
            this.writeRequestBody(httpURLConnection2.getOutputStream(), var1_1.getRequestBody());
        }
        return httpURLConnection;
    }

    private void writeRequestBody(OutputStream outputStream, String requestBody) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object = this = byteArrayOutputStream;
        ((ByteArrayOutputStream)object)();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)this);
        gZIPOutputStream.write(requestBody.getBytes(Charset.forName("UTF8")));
        gZIPOutputStream.close();
        outputStream.write(((ByteArrayOutputStream)object).toByteArray());
        byteArrayOutputStream.close();
    }

    private HttpURLConnection connectWithFileDownloadType(Request request) throws IOException {
        InstabugSDKLogger.d(TAG, "Connect to: " + request.getRequestUrl() + " with fileDownload type");
        return this.connectWithNormalType(request);
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection connectWithMultiPartType(Request request) throws IOException {
        void var1_1;
        c c2;
        InstabugSDKLogger.d(TAG, "Connect to: " + request.getRequestUrl() + " with multiPart type");
        Object this_ = ((NetworkManager)this_).buildConnection(request);
        ((HttpURLConnection)this_).setRequestMethod(request.getRequestMethod().toString());
        ((URLConnection)this_).setRequestProperty("Connection", "Keep-Alive");
        ((URLConnection)this_).setRequestProperty("Cache-Control", "no-cache");
        ((URLConnection)this_).setRequestProperty("Content-Encoding", "");
        c c3 = c2;
        c2 = new c((HttpURLConnection)this_);
        for (Request.RequestParameter requestParameter : request.getRequestBodyParameters()) {
            c3.a(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        Object object = this_;
        c c4 = c3;
        this_ = var1_1.getFileToUpload();
        c4.a(((Request.FileToUpload)this_).getFilePartName(), new File(((Request.FileToUpload)this_).getFilePath()), ((Request.FileToUpload)this_).getFileName(), ((Request.FileToUpload)this_).getFileType());
        c4.a();
        return object;
    }

    private RequestResponse handleRequestResponse(HttpURLConnection connection) throws IOException {
        RequestResponse requestResponse;
        RequestResponse requestResponse2 = requestResponse;
        requestResponse2();
        int this22 = connection.getResponseCode();
        requestResponse2.setResponseCode(this22);
        requestResponse2.setHeaders(this22.getHeaderFields(connection));
        InstabugSDKLogger.d(TAG, "Request response code: " + this22);
        String this22 = this22.convertStreamToString(connection.getInputStream());
        requestResponse2.setResponseBody(this22);
        InstabugSDKLogger.addVerboseLog(TAG, "Request response: " + this22);
        connection.disconnect();
        return requestResponse;
    }

    private RequestResponse handleMultipartRequestResponse(HttpURLConnection connection) throws IOException {
        return this.handleRequestResponse(connection);
    }

    private RequestResponse handleFileDownloadRequestResponse(Request request, HttpURLConnection connection) throws IOException {
        RequestResponse requestResponse;
        RequestResponse requestResponse2 = requestResponse;
        requestResponse2();
        int this_ = connection.getResponseCode();
        requestResponse2.setResponseCode(this_);
        requestResponse2.setHeaders(this_.getHeaderFields(connection));
        InstabugSDKLogger.d(TAG, "File downloader request response code: " + this_);
        this_.copyStream(connection.getInputStream(), new FileOutputStream(request.getDownloadedFile()));
        requestResponse2.setResponseBody(request.getDownloadedFile());
        InstabugSDKLogger.addVerboseLog(TAG, "File downloader request response: " + request.getDownloadedFile().getPath());
        connection.disconnect();
        return requestResponse;
    }

    private void handleServerConnectionError(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getErrorStream();
        try {
            InstabugSDKLogger.e(TAG, "Error getting Network request response: " + this.convertStreamToString(inputStream));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(TAG, outOfMemoryError.getMessage(), outOfMemoryError);
        }
    }

    /*
     * Exception decompiling
     */
    private String convertStreamToString(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [16 : 75->83)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) != -1) {
            void var2_3;
            var2_3.write(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getHeaderFields(HttpURLConnection connection) {
        HashMap hashMap;
        HashMap this_ = hashMap;
        hashMap = new HashMap();
        for (String string2 : connection.getHeaderFields().keySet()) {
            void var1_1;
            this_.put(string2, var1_1.getHeaderField(string2));
        }
        return this_;
    }

    public void setOnDoRequestListener(@Nullable OnDoRequestListener onDoRequestListener) {
        this.onDoRequestListener = onDoRequestListener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Observable<RequestResponse> doRequest(@NonNull Request request) {
        void var1_1;
        OnDoRequestListener onDoRequestListener = this.onDoRequestListener;
        if (onDoRequestListener != null) {
            onDoRequestListener.onRequestStarted((Request)var1_1);
        }
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<RequestResponse>((Request)var1_1){
            final /* synthetic */ Request a;
            {
                this.a = request;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void subscribe(ObservableEmitter<RequestResponse> observableEmitter) {
                if (NetworkManager.this.onDoRequestListener != null) {
                    NetworkManager.this.onDoRequestListener.onStart();
                }
                try {
                    block22: {
                        HttpURLConnection httpURLConnection;
                        block23: {
                            int n;
                            block21: {
                                HttpURLConnection httpURLConnection2;
                                block20: {
                                    InstabugSDKLogger.d(NetworkManager.TAG, "Request Url: " + this.a.getRequestUrl());
                                    httpURLConnection = null;
                                    n = b.a[this.a.getRequestType().ordinal()];
                                    if (n == 1) break block20;
                                    if (n != 2) {
                                        if (n == 3) {
                                            httpURLConnection2 = NetworkManager.this.connectWithMultiPartType(this.a);
                                        }
                                        break block21;
                                    } else {
                                        httpURLConnection2 = NetworkManager.this.connectWithFileDownloadType(this.a);
                                    }
                                    break block21;
                                }
                                httpURLConnection2 = httpURLConnection = NetworkManager.this.connectWithNormalType(this.a);
                            }
                            if (httpURLConnection == null) break block22;
                            if (httpURLConnection.getResponseCode() >= 400) {
                                InstabugSDKLogger.e(NetworkManager.TAG, "Network request got error");
                                NetworkManager.this.handleServerConnectionError(httpURLConnection);
                            }
                            InstabugSDKLogger.d(NetworkManager.TAG, "Network request completed successfully");
                            n = b.a[this.a.getRequestType().ordinal()];
                            if (n == 1) break block23;
                            if (n != 2) {
                                if (n == 3) {
                                    observableEmitter.onNext((Object)NetworkManager.this.handleMultipartRequestResponse(httpURLConnection));
                                }
                                break block22;
                            } else {
                                observableEmitter.onNext((Object)NetworkManager.this.handleFileDownloadRequestResponse(this.a, httpURLConnection));
                            }
                            break block22;
                        }
                        observableEmitter.onNext((Object)NetworkManager.this.handleRequestResponse(httpURLConnection));
                    }
                    if (NetworkManager.this.onDoRequestListener != null) {
                        NetworkManager.this.onDoRequestListener.onComplete();
                    }
                    observableEmitter.onComplete();
                    return;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), iOException);
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)iOException);
                            return;
                        }
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), iOException);
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), iOException);
                        return;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), interruptedIOException);
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)interruptedIOException);
                            return;
                        }
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), interruptedIOException);
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), interruptedIOException);
                    }
                }
            }
        });
    }

    public Request buildRequest(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod) throws JSONException {
        return this.buildRequest(context, endpoint, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod, RequestType requestType) throws JSONException {
        Request request = new Request(endpoint, requestType);
        request.setRequestMethod(requestMethod);
        return this.buildRequest(context, request);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String requestUrl, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        return this.buildRequest(context, requestUrl, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String requestUrl, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        Request request = new Request(requestUrl, requestType);
        request.setRequestMethod(requestMethod);
        return this.buildRequest(context, request);
    }

    public Request buildRequestWithoutUUID(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod) throws JSONException {
        Request request = new Request(endpoint, RequestType.NORMAL);
        request.setRequestMethod(requestMethod);
        request.addParameter(APP_TOKEN, Instabug.getAppToken());
        return request;
    }

    public HttpURLConnection buildConnection(Request request) throws IOException {
        HttpURLConnection this_ = (HttpURLConnection)new URL(request.getRequestUrl()).openConnection();
        this_.setRequestProperty("Content-Type", "application/json");
        this_.setRequestProperty("Accept-Charset", "UTF-8");
        this_.setRequestProperty("Content-Encoding", "gzip");
        for (Request.RequestParameter requestParameter : request.getHeaders()) {
            this_.setRequestProperty(requestParameter.getKey(), (String)requestParameter.getValue());
        }
        HttpURLConnection httpURLConnection = this_;
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    public HttpURLConnection setURLConnectionTimeOut(HttpURLConnection httpURLConnection, int readTimeOut, int connectionTimeOut) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection.setReadTimeout(readTimeOut);
        httpURLConnection2.setConnectTimeout(connectionTimeOut);
        return httpURLConnection2;
    }

    public static interface OnDoRequestListener {
        public void onRequestStarted(Request var1);

        public void onStart();

        public void onComplete();
    }

    public static enum RequestType {
        NORMAL,
        MULTI_PART,
        FILE_DOWNLOAD;

    }
}

