/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics.model;

import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Api {
    private static final String KEY_TIME_STAMP = "time_stamp";
    private static final String KEY_METHOD = "method";
    private static final String KEY_IS_DEPRECATED = "is_deprecated";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_COUNT = "count";
    private long timeStamp;
    private String apiName;
    private boolean isDeprecated;
    private int count;
    private ArrayList<Parameter> parameters;

    public Api() {
        Api api = this;
        api.count = 1;
        api.setTimeStamp(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
    }

    public static JSONArray toJson(ArrayList<Api> apis) {
        ArrayList<Api> arrayList;
        JSONArray jSONArray;
        JSONArray jSONArray2 = apis;
        apis = jSONArray;
        jSONArray = new JSONArray();
        Iterator iterator = jSONArray2.iterator();
        while (iterator.hasNext()) {
            arrayList.put(((Api)iterator.next()).toJson());
        }
        return arrayList;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Api setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public String getApiName() {
        return this.apiName;
    }

    public Api setApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Api setDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public Api setParameters(ArrayList<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = new JSONObject().put(KEY_TIME_STAMP, this.getTimeStamp());
        JSONObject jSONObject4 = jSONObject3.put(KEY_METHOD, (Object)this.getApiName());
        JSONObject jSONObject5 = jSONObject4.put(KEY_IS_DEPRECATED, this.isDeprecated());
        JSONObject jSONObject6 = jSONObject5.put(KEY_COUNT, this.getCount());
        try {
            jSONObject6.put(KEY_PARAMETERS, (Object)Parameter.toJson(this.getParameters()));
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(Api.class, jSONException.getMessage(), jSONException);
        }
        return jSONObject2;
    }

    public static class Parameter {
        private static final String KEY_NAME = "name";
        private static final String KEY_TYPE = "type";
        private static final String KEY_VALUE = "value";
        private String name;
        private String type;
        private String value;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Parameter fromJson(JSONObject parameterJsonObject) {
            Parameter parameter;
            Parameter parameter2 = parameter;
            parameter = new Parameter();
            try {
                JSONObject jSONObject;
                if (parameterJsonObject.has(KEY_NAME)) {
                    parameter2.name = jSONObject.getString(KEY_NAME);
                }
                if (jSONObject.has(KEY_TYPE)) {
                    parameter2.type = jSONObject.getString(KEY_TYPE);
                }
                if (!jSONObject.has(KEY_VALUE)) return parameter2;
                parameter2.value = jSONObject.getString(KEY_VALUE);
                return parameter2;
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
            }
            return parameter2;
        }

        public static JSONArray toJson(ArrayList<Parameter> parameters) {
            ArrayList<Parameter> arrayList;
            JSONArray jSONArray;
            JSONArray jSONArray2 = parameters;
            parameters = jSONArray;
            jSONArray = new JSONArray();
            Iterator iterator = jSONArray2.iterator();
            while (iterator.hasNext()) {
                arrayList.put(((Parameter)iterator.next()).toJson());
            }
            return arrayList;
        }

        public static ArrayList<Parameter> fromJson(JSONArray parametersJsonArray) {
            JSONArray jSONArray;
            ArrayList<Parameter> arrayList;
            ArrayList<Parameter> arrayList2 = arrayList;
            arrayList = new ArrayList<Parameter>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    arrayList2.add(Parameter.fromJson(jSONArray.getJSONObject(i2)));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
                }
                continue;
            }
            return arrayList2;
        }

        public String getName() {
            return this.name;
        }

        public Parameter setName(String name) {
            this.name = name;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Parameter setType(Class<?> cls) {
            this.type = cls.getSimpleName();
            return this;
        }

        public String getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public Parameter setValue(Object value) {
            void var1_1;
            this.value = value == null ? "null" : var1_1.toString();
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JSONObject toJson() {
            JSONObject jSONObject;
            block8: {
                block7: {
                    JSONObject jSONObject2;
                    jSONObject = jSONObject2;
                    jSONObject2 = new JSONObject();
                    if (this.getName() == null) break block7;
                    jSONObject.put(KEY_NAME, (Object)this.getName());
                }
                if (this.getType() == null) break block8;
                jSONObject.put(KEY_TYPE, (Object)this.getType());
            }
            if (this.getValue() == null) return jSONObject;
            try {
                jSONObject.put(KEY_VALUE, (Object)this.getValue());
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
            }
            return jSONObject;
        }
    }
}

