/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class InstabugDateFormatter {
    public static long getCurrentUTCTimeStampInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentUTCTimeStampInMiliSeconds() {
        return System.currentTimeMillis();
    }

    public static String getCurrentDateAsString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatUTCDate(long UTCDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(UTCDate * 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String convertUnixTimeToFormattedDate(long UNIXTime) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        SimpleDateFormat simpleDateFormat3 = simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat3("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(InstabugDateFormatter.convertUnixTimeToDate(UNIXTime));
    }

    public static String convertUnixTimeToFormattedDate(long UNIXTime, String format) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        SimpleDateFormat simpleDateFormat3 = simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat3(format, Locale.US);
        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(InstabugDateFormatter.convertUnixTimeToDate(UNIXTime));
    }

    public static Date convertUnixTimeToDate(long UNIXTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(UNIXTime);
        return calendar.getTime();
    }

    public static String formatMessageDate(long messageUTCDate) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat2("dd-MMM HH:mm", Locale.US);
        return simpleDateFormat.format(messageUTCDate * 1000L);
    }

    public static String formatConversationLastMessageDate(long conversationLastMessagetUTCDate) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat2("dd MMM", Locale.US);
        return simpleDateFormat.format(conversationLastMessagetUTCDate * 1000L);
    }

    public static Date getStandardizedDate(Date date) {
        return new Date(date.getTime());
    }

    public static Date getDate(String dateText) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return simpleDateFormat.parse(dateText);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }
}

