/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import com.instabug.library.internal.storage.executor.DeleteOperationExecutor;
import com.instabug.library.internal.storage.executor.ReadOperationExecutor;
import com.instabug.library.internal.storage.executor.WriteOperationExecutor;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public final class DiskUtils {
    public static final String TAG = "DiskUtils";
    private final Context context;

    private DiskUtils(Context context) {
        this.context = context;
    }

    public static File getInstabugDirectory(Context context) {
        File file;
        Object object;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = DiskUtils.getInternalStoragePath(object);
                InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
            }
        } else {
            object = DiskUtils.getInternalStoragePath(object);
            InstabugSDKLogger.i(TAG, "External storage not available, saving file to internal storage.");
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static synchronized File getInsatbugLogDirectory(String directoryLogName, Context context) {
        File file;
        context = DiskUtils.getInstabugDirectory((Context)context).getAbsolutePath().concat("/");
        File file2 = file;
        if (!new File(((String)context).concat(directoryLogName)).exists() && !file2.mkdir()) {
            Log.w((String)TAG, (String)"failed logs directory to create");
        }
        return file2;
    }

    private static String getInternalStoragePath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        void var1_1;
        if (bitmap != null && var1_1 != null) {
            Bitmap bitmap2;
            FileOutputStream fileOutputStream;
            InstabugSDKLogger.addVerboseLog(DiskUtils.class, "starting save viewHierarchy image, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2((File)var1_1);
            bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream2);
            fileOutputStream.close();
            InstabugSDKLogger.addVerboseLog(DiskUtils.class, "viewHierarchy image saved, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
        }
    }

    public static void cleanDirectory(File directory) {
        File[] fileArray;
        if (directory.exists() && fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.delete()) continue;
                InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFromUriIntoFile(Context context, Uri source, File target) throws IOException {
        void var1_1;
        int n;
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(source));
        InstabugSDKLogger.d(TAG, "Target file path: " + target.getPath());
        source = bufferedOutputStream;
        bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)target)));
        Object object = new byte[32768];
        while ((n = bufferedInputStream2.read((byte[])object)) > 0) {
            var1_1.write((byte[])object, 0, n);
        }
        var1_1.close();
        bufferedInputStream2.close();
    }

    public static void deleteFile(final String fileLocalPath) {
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                new File(fileLocalPath).delete();
            }
        });
    }

    public static DiskUtils with(Context context) {
        return new DiskUtils(context);
    }

    public static boolean isFileExist(String path) {
        return new File(path).exists();
    }

    public static File createStateTextFile(Context context) {
        return new File(context.getFilesDir().getAbsolutePath() + File.pathSeparator + "crash_state" + File.pathSeparator + System.currentTimeMillis() + ".txt");
    }

    public ReadOperationExecutor readOperation(@NonNull DiskOperation<String, Void> operation) {
        return new ReadOperationExecutor(operation);
    }

    public WriteOperationExecutor writeOperation(@NonNull DiskOperation<Uri, Context> operation) {
        return new WriteOperationExecutor(this.context, operation);
    }

    public DeleteOperationExecutor deleteOperation(@NonNull DiskOperation<Boolean, Void> operation) {
        return new DeleteOperationExecutor(operation);
    }
}

