/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AttachmentsUtility {
    public static final String TAG = "AttachmentsUtility";
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        context = AttachmentsUtility.getNewDirectory(context, "videos");
        Object object = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object = "video-" + ((DateFormat)object).format(new Date()) + ".mp4";
        return new File((File)context, (String)object);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    public static File getNewDirectory(Context context, String directoryName) {
        File file;
        File file2 = file;
        if (!new File(DiskUtils.getInstabugDirectory(context) + "/" + directoryName + "/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "frames");
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        if ((activity = activity.managedQuery(uri, new String[]{"_data"}, null, null, null)) != null) {
            Activity activity2;
            Activity activity3 = activity2;
            int n = activity3.getColumnIndexOrThrow("_data");
            activity2.moveToFirst();
            return activity3.getString(n);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(Context context, Uri originalUri, String fileNameWithExtension) {
        File file;
        block6: {
            File file2;
            Context context2;
            void var1_2;
            if (originalUri == null) {
                return null;
            }
            Object object = var1_2.getLastPathSegment().toLowerCase();
            File file3 = AttachmentsUtility.getFilesAttachmentDirectory(context2);
            if (file != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_2)) {
                object = file;
            }
            file = file2;
            if (new File(file3, (String)object).exists()) {
                File file4;
                file = file4;
                file4 = new File(file3, String.valueOf(System.currentTimeMillis()) + "_" + (String)object);
            }
            try {
                DiskUtils.copyFromUriIntoFile(context2, (Uri)var1_2, file);
                if (AttachmentsUtility.validateFileSize(file, 50.0)) break block6;
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
                return null;
            }
            InstabugSDKLogger.w(TAG, "Attachment file size exceeds than the limit 50.0");
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileAttachmentUri(Context context, Uri originalUri) {
        return AttachmentsUtility.getNewFileAttachmentUri(context, originalUri, null);
    }

    /*
     * WARNING - void declaration
     */
    public static File getAttachmentFile(Context context, String fileName) {
        File file;
        context = AttachmentsUtility.getFilesAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)context, fileName).exists()) {
            void var1_1;
            Context context2;
            File file3;
            file2 = file3;
            file3 = new File((File)context2, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        Object object = AttachmentsUtility.getAttachmentFile(context, fileName);
        try {
            AttachmentsUtility.saveBytesToFile(data, (File)object);
        }
        catch (IOException iOException) {
            object = iOException;
            InstabugSDKLogger.e(TAG, iOException.getMessage(), (Throwable)object);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(data);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFileSize(File file, double maxFileSize) {
        double d2;
        long l = file.length();
        double d3 = (double)l / 1048576.0;
        if (d2 > maxFileSize) {
            void var1_1;
            InstabugSDKLogger.w(TAG, "External attachment file size is " + l + " bytes or " + d3 + " MBs > maxFileSize " + (double)var1_1);
            return false;
        }
        return true;
    }

    public static void encryptAttachments(List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachments");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted()) continue;
                Attachment attachment2 = attachment;
                InstabugCore.encrypt(attachment2.getLocalPath());
                attachment2.setEncrypted(true);
            }
        }
    }

    public static void encryptAttachmentsAndUpdateDb(List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachmentsAndUpdateDb");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ContentValues contentValues;
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted()) continue;
                Attachment attachment2 = attachment;
                InstabugCore.encrypt(attachment2.getLocalPath());
                attachment2.setEncrypted(true);
                attachment = contentValues;
                new ContentValues().put("encrypted", Boolean.valueOf(true));
                AttachmentsDbHelper.update(attachment2.getId(), (ContentValues)attachment);
            }
        }
    }

    public static void decryptAttachmentAndUpdateDb(Attachment attachment) {
        InstabugSDKLogger.d(TAG, "decryptAttachmentAndUpdateDb");
        if (attachment.isEncrypted()) {
            ContentValues contentValues;
            Attachment attachment2;
            Attachment attachment3 = attachment2;
            InstabugCore.decrypt(attachment3.getLocalPath());
            attachment3.setEncrypted(false);
            attachment2 = contentValues;
            new ContentValues().put("encrypted", Boolean.valueOf(false));
            AttachmentsDbHelper.update(attachment3.getId(), (ContentValues)attachment2);
        }
    }
}

