/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.instabug.library.Instabug;
import com.instabug.library.PresentationManager;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class ExtraScreenshotHelper {
    public static final String TAG = "ExtraScreenshotHelper";
    private ImageButton captureButton;
    private boolean isCaptureButtonShown = false;
    private Disposable currentActivityLifeCycleDisposable;
    private Disposable mediaProjectionScreenshotDisposable;
    private OnCaptureListener onCaptureListener;

    /*
     * WARNING - void declaration
     */
    private void show(@NonNull Activity hostActivity) {
        if (!this.isCaptureButtonShown && !SettingsManager.getInstance().isProcessingForeground()) {
            void var1_1;
            ExtraScreenshotHelper extraScreenshotHelper = this;
            extraScreenshotHelper.captureButton = extraScreenshotHelper.createCaptureButton((Activity)var1_1);
            ViewCompat.setElevation((View)extraScreenshotHelper.captureButton, (float)ViewUtils.convertDpToPx(Instabug.getApplicationContext(), 5.0f));
            ((ViewGroup)var1_1.getWindow().getDecorView()).addView((View)this.captureButton, (ViewGroup.LayoutParams)this.createCaptureButtonContainer((Activity)var1_1));
            this.isCaptureButtonShown = true;
            this.captureButton.setOnClickListener(new View.OnClickListener((Activity)var1_1){
                final /* synthetic */ Activity a;
                {
                    this.a = activity;
                }

                public void onClick(View view) {
                    a a2 = this;
                    a2.ExtraScreenshotHelper.this.hide();
                    ExtraScreenshotHelper extraScreenshotHelper = a2.ExtraScreenshotHelper.this;
                    extraScreenshotHelper.captureExtraScreenshot(this.a, extraScreenshotHelper.onCaptureListener);
                }
            });
            return;
        }
    }

    private ImageButton createCaptureButton(Activity hostActivity) {
        ImageButton imageButton;
        ExtraScreenshotHelper extraScreenshotHelper = this = imageButton;
        extraScreenshotHelper((Context)hostActivity);
        extraScreenshotHelper.setId(R.id.instabug_extra_screenshot_button);
        extraScreenshotHelper.setScaleType(ImageView.ScaleType.CENTER);
        this.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(ContextCompat.getDrawable((Context)hostActivity, (int)R.drawable.instabug_bg_white_oval)));
        imageButton.setImageDrawable(AppCompatResources.getDrawable((Context)hostActivity, (int)R.drawable.ib_ic_core_screenshot));
        return imageButton;
    }

    /*
     * WARNING - void declaration
     */
    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity hostActivity) {
        void var1_1;
        FrameLayout.LayoutParams layoutParams;
        ExtraScreenshotHelper this_ = layoutParams;
        new FrameLayout.LayoutParams(-2, -2, 81).setMargins(0, 0, 0, 20);
        Resources resources = hostActivity.getResources();
        if (Build.VERSION.SDK_INT >= 21 && ScreenUtility.hasNavBar((Context)var1_1) && !ScreenUtility.isLandscape((Activity)var1_1)) {
            ((FrameLayout.LayoutParams)this_).bottomMargin += ScreenUtility.getNavigationBarHeight(resources);
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    private void captureExtraScreenshot(Activity hostActivity, OnCaptureListener onCaptureListener) {
        void var2_2;
        void var1_1;
        if (this.isUsingMediaProjection()) {
            com.instabug.library.screenshot.a.c.a((Context)var1_1, new ScreenshotProvider.ScreenshotCapturingListener((Activity)var1_1, (OnCaptureListener)var2_2){
                final /* synthetic */ Activity a;
                final /* synthetic */ OnCaptureListener b;
                {
                    this.a = activity;
                    this.b = onCaptureListener;
                }

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    BitmapUtils.maskBitmap(bitmap, SettingsManager.getInstance(), null);
                    BitmapUtils.saveBitmap(bitmap, (Context)this.a, new BitmapUtils.OnSaveBitmapCallback(){

                        @Override
                        public void onSuccess(Uri uri) {
                            OnCaptureListener onCaptureListener = b;
                            if (onCaptureListener != null) {
                                onCaptureListener.onExtraScreenshotCaptured(uri);
                            }
                        }

                        @Override
                        public void onError(Throwable throwable) {
                            InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
                        }
                    });
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    OnCaptureListener onCaptureListener = this.b;
                    if (onCaptureListener != null) {
                        onCaptureListener.onExtraScreenshotError(throwable);
                    }
                    ExtraScreenshotHelper.this.reset();
                    InstabugSDKLogger.e(ExtraScreenshotHelper.TAG, throwable.getMessage(), throwable);
                }
            });
        } else {
            ScreenshotProvider.a((Activity)var1_1, new ScreenshotProvider.ScreenshotCapturingListener(this, (Activity)var1_1, (OnCaptureListener)var2_2){
                final /* synthetic */ Activity a;
                final /* synthetic */ OnCaptureListener b;
                {
                    this.a = activity;
                    this.b = onCaptureListener;
                }

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    BitmapUtils.saveBitmap(bitmap, (Context)this.a, new BitmapUtils.OnSaveBitmapCallback(){

                        @Override
                        public void onSuccess(Uri uri) {
                            OnCaptureListener onCaptureListener = b;
                            if (onCaptureListener != null) {
                                onCaptureListener.onExtraScreenshotCaptured(uri);
                            }
                        }

                        @Override
                        public void onError(Throwable throwable) {
                            InstabugSDKLogger.e(ExtraScreenshotHelper.TAG, throwable.getMessage(), throwable);
                        }
                    });
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    InstabugSDKLogger.e(ExtraScreenshotHelper.TAG, throwable.getMessage(), throwable);
                }
            });
        }
    }

    private void reset() {
        this.hide();
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        }
    }

    private boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    private void hide() {
        ImageButton imageButton;
        if (this.isCaptureButtonShown && (imageButton = this.captureButton) != null && imageButton.getParent() != null && this.captureButton.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.captureButton.getParent()).removeView((View)this.captureButton);
            this.isCaptureButtonShown = false;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n = e.a[activityLifeCycleEvent.ordinal()];
                if (n != 1) {
                    if (n == 2) {
                        ExtraScreenshotHelper.this.handleCurrentActivityPauseEvent();
                    }
                } else {
                    ExtraScreenshotHelper.this.handleCurrentActivityResumeEvent();
                }
            }
        });
    }

    private void handleCurrentActivityResumeEvent() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        } else {
            InstabugSDKLogger.v(TAG, "current activity equal null");
        }
    }

    private void handleCurrentActivityPauseEvent() {
        this.hide();
    }

    public void init(OnCaptureListener onCaptureListener) {
        this.onCaptureListener = onCaptureListener;
        this.subscribeToCurranActivityLifeCycle();
        InvocationManager.getInstance().switchOffInvocation();
        PresentationManager.getInstance().setInInstabugContext(true);
    }

    public void release() {
        ImageButton imageButton = this.captureButton;
        if (imageButton != null) {
            imageButton.setOnClickListener(null);
        }
        this.captureButton = null;
        this.onCaptureListener = null;
        imageButton = this.currentActivityLifeCycleDisposable;
        if (imageButton != null && !imageButton.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        PresentationManager.getInstance().setInInstabugContext(false);
        InvocationManager.getInstance().switchOnInvocation();
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);

        public void onExtraScreenshotError(Throwable var1);
    }
}

