/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.network.Request;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static LinkedHashMap<String, b> currentDownloadingFiles = new LinkedHashMap();

    public static com.instabug.library.internal.storage.cache.a getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new com.instabug.library.internal.storage.cache.a(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        return (com.instabug.library.internal.storage.cache.a)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    public static AssetEntity createEmptyEntity(Context context, String fileUrl, AssetEntity.AssetType assetType) {
        File file;
        File file2 = file;
        file = new File(AssetsCacheManager.getCashDirectory(context), String.valueOf(fileUrl.hashCode()));
        return new AssetEntity(String.valueOf(fileUrl.hashCode()), assetType, fileUrl, file2);
    }

    /*
     * WARNING - void declaration
     */
    public static void getAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        void var2_2;
        void var1_1;
        Object object = AssetsCacheManager.getCache();
        object = object != null ? (AssetEntity)((InMemoryCache)object).get(var1_1.getKey()) : null;
        if (object != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            var2_2.onSuccess((AssetEntity)object);
        } else if (AssetsCacheManager.isDownloading(var1_1.getKey())) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish((AssetEntity)var1_1, (OnDownloadFinished)var2_2);
        } else {
            Context context2;
            InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(context2, (AssetEntity)var1_1, (OnDownloadFinished)var2_2);
        }
    }

    public static void downloadAssetEntity(Context context, final AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        b b2;
        b b3 = b2;
        b3();
        b2.a(assetEntity);
        List<OnDownloadFinished> list = b2.c();
        list.add(onDownloadFinished);
        b2.a(list);
        b2.a((Disposable)com.instabug.library.network.e.b.a().a(context, assetEntity, new Request.Callbacks<AssetEntity, Throwable>(){

            public void a(AssetEntity assetEntity3) {
                AssetEntity assetEntity2 = assetEntity3;
                AssetsCacheManager.addAssetEntity(assetEntity2);
                AssetsCacheManager.notifyDownloadFinishedSuccessfully(assetEntity2);
            }

            public void a(Throwable throwable) {
                a a2 = this;
                InstabugSDKLogger.e(a2, "downloading asset entity got error: ", throwable);
                AssetsCacheManager.notifyDownloadFailed(a2.assetEntity, throwable);
            }
        }));
        currentDownloadingFiles.put(b3.a().getKey(), b3);
    }

    public static void addAssetEntity(AssetEntity assetEntity) {
        com.instabug.library.internal.storage.cache.a a2 = AssetsCacheManager.getCache();
        if (a2 != null) {
            AssetEntity assetEntity2;
            a2.put(assetEntity2.getKey(), assetEntity2);
        }
    }

    public static boolean isDownloading(String key) {
        return currentDownloadingFiles.get(key) != null;
    }

    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        List<OnDownloadFinished> list = currentDownloadingFiles.get(assetEntity.getKey()).c();
        list.add(onDownloadFinished);
        currentDownloadingFiles.get(assetEntity.getKey()).a(list);
    }

    public static void notifyDownloadFinishedSuccessfully(AssetEntity assetEntity) {
        for (OnDownloadFinished onDownloadFinished : currentDownloadingFiles.get(assetEntity.getKey()).c()) {
            AssetEntity assetEntity2;
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onSuccess(assetEntity2);
            currentDownloadingFiles.remove(assetEntity2.getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable error) {
        for (OnDownloadFinished onDownloadFinished : currentDownloadingFiles.get(assetEntity.getKey()).c()) {
            AssetEntity assetEntity2;
            void var1_1;
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onFailed((Throwable)var1_1);
            currentDownloadingFiles.remove(assetEntity2.getKey());
        }
    }

    public static void stopRunningDownloads() {
        Iterator<Map.Entry<String, b>> iterator = currentDownloadingFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().b().dispose();
        }
        currentDownloadingFiles.clear();
    }

    public static void clearRedundantFiles(Context context) {
        File[] fileArray;
        block5: {
            fileArray = AssetsCacheManager.getCashDirectory(context).listFiles();
            if (fileArray != null) break block5;
            return;
        }
        int n = fileArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            try {
                fileArray[i2].delete();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(AssetsCacheManager.class, exception.getMessage(), exception);
                break;
            }
            continue;
        }
    }

    public static void cleanUpCache(Context context) {
        Context context2;
        Cache cache;
        AssetsCacheManager.stopRunningDownloads();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context2);
    }

    public static File getCashDirectory(Context context) {
        File file;
        Object object;
        if (Environment.getExternalStorageState().equals("mounted") && object.getExternalCacheDir() != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            object = object.getExternalCacheDir().getPath();
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            object = object.getCacheDir().getAbsolutePath();
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/assetCache").exists()) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + file2.mkdirs());
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class b {
        public AssetEntity a;
        public Disposable b;
        public List<OnDownloadFinished> c = new ArrayList<OnDownloadFinished>();

        public b a(AssetEntity assetEntity) {
            this.a = assetEntity;
            return this;
        }

        public Disposable b() {
            return this.b;
        }

        public b a(List<OnDownloadFinished> list) {
            this.c = list;
            return this;
        }

        public AssetEntity a() {
            return this.a;
        }

        public b a(Disposable disposable) {
            this.b = disposable;
            return this;
        }

        public List<OnDownloadFinished> c() {
            return this.c;
        }
    }
}

