/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.widget.ImageView;
import com.instabug.library.util.BitmapUtils;
import java.lang.ref.WeakReference;

public class BitmapWorkerTask
extends AsyncTask<String, Void, Bitmap> {
    private final WeakReference<ImageView> imageViewReference;
    private float targetWidth;
    private float targetHeight;
    private boolean resize;
    private OnImageLoadedListener onImageLoadedListener;

    public BitmapWorkerTask(ImageView imageView) {
        this.imageViewReference = new WeakReference<ImageView>(imageView);
    }

    public BitmapWorkerTask(ImageView imageView, float targetWidth, float targetHeight) {
        BitmapWorkerTask bitmapWorkerTask = this;
        this(imageView);
        this.targetWidth = targetWidth;
        bitmapWorkerTask.targetHeight = targetHeight;
        bitmapWorkerTask.resize = true;
    }

    public BitmapWorkerTask(ImageView imageView, OnImageLoadedListener onImageLoadedListener) {
        this(imageView);
        this.onImageLoadedListener = onImageLoadedListener;
    }

    public BitmapWorkerTask(ImageView imageView, float targetWidth, float targetHeight, OnImageLoadedListener onImageLoadedListener) {
        this(imageView, targetWidth, targetHeight);
        this.onImageLoadedListener = onImageLoadedListener;
    }

    protected Bitmap doInBackground(String ... params) {
        Bitmap bitmap;
        params = BitmapUtils.decodeSampledBitmapFromLocalPath(params[0]);
        if (this.resize) {
            bitmap = BitmapUtils.resizeBitmap(bitmap, this.targetWidth, this.targetHeight);
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    protected void onPostExecute(Bitmap bitmap) {
        ImageView imageView;
        if (bitmap != null && (imageView = (ImageView)((BitmapWorkerTask)((Object)onImageLoadedListener)).imageViewReference.get()) != null) {
            void var1_1;
            imageView.setImageBitmap((Bitmap)var1_1);
            OnImageLoadedListener onImageLoadedListener = ((BitmapWorkerTask)((Object)onImageLoadedListener)).onImageLoadedListener;
            if (onImageLoadedListener != null) {
                onImageLoadedListener.onImageLoaded();
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded();
    }
}

